/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.transaction;

import com.atlassian.core.ofbiz.util.CoreTransactionUtil;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.database.NestedConnection;
import com.atlassian.jira.transaction.RequestLocalTransactionRunnableQueueFactory;
import com.atlassian.jira.transaction.RunnablesQueue;
import com.atlassian.jira.transaction.Transaction;
import com.atlassian.jira.transaction.TransactionRuntimeException;
import com.atlassian.jira.transaction.TransactionSupport;
import javax.annotation.Nonnull;
import org.ofbiz.core.entity.GenericTransactionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionSupportImpl
implements TransactionSupport {
    private static final Logger log = LoggerFactory.getLogger(TransactionSupportImpl.class);
    private final ApplicationProperties applicationProperties;
    private final RequestLocalTransactionRunnableQueueFactory requestLocalTransactionRunnableQueueFactory;

    public TransactionSupportImpl(ApplicationProperties applicationProperties, RequestLocalTransactionRunnableQueueFactory requestLocalTransactionRunnableQueueFactory) {
        this.applicationProperties = applicationProperties;
        this.requestLocalTransactionRunnableQueueFactory = requestLocalTransactionRunnableQueueFactory;
    }

    @Override
    public Transaction begin() throws TransactionRuntimeException {
        RunnablesQueue runQueue = this.requestLocalTransactionRunnableQueueFactory.getRunnablesQueue();
        if (this.startedTransaction(false)) {
            return new TransactionImpl(new NestedConnection(CoreTransactionUtil.getConnection()), runQueue);
        }
        return new JoinedTransaction(new NestedConnection(CoreTransactionUtil.getConnection()), runQueue);
    }

    private boolean startedTransaction(boolean forceTxn) throws TransactionRuntimeException {
        if (!forceTxn && this.applicationProperties.getOption("jira.db.txns.disabled")) {
            return false;
        }
        return this.beginTxn();
    }

    boolean beginTxn() throws TransactionRuntimeException {
        try {
            return CoreTransactionUtil.begin();
        }
        catch (GenericTransactionException e) {
            throw new TransactionRuntimeException(e);
        }
    }

    private static class TransactionImpl
    implements Transaction {
        private final NestedConnection nestedConnection;
        private final RunnablesQueue runQueue;
        private boolean committed = false;

        private TransactionImpl(NestedConnection nestedConnection, RunnablesQueue runQueue) {
            this.runQueue = runQueue;
            this.nestedConnection = nestedConnection;
        }

        @Override
        public void runAfterSuccessfulCommit(@Nonnull Runnable runnable) {
            this.runQueue.offer(runnable);
        }

        @Override
        public NestedConnection getNestedConnection() {
            return this.nestedConnection;
        }

        @Override
        public void commit() throws TransactionRuntimeException {
            try {
                CoreTransactionUtil.commit(true);
                this.committed = true;
                this.runQueue.runAndClear();
            }
            catch (GenericTransactionException e) {
                log.error("Unable to commit transaction : " + e.getMessage(), (Throwable)e);
                throw new TransactionRuntimeException(e);
            }
            finally {
                this.runQueue.clear();
            }
        }

        @Override
        public void rollback() throws TransactionRuntimeException {
            if (this.committed) {
                throw new IllegalStateException("The transaction has already been committed and hence you cannot rollback");
            }
            try {
                CoreTransactionUtil.rollback(true);
            }
            catch (GenericTransactionException e) {
                log.error("Unable to rollback transaction : " + e.getMessage(), (Throwable)e);
                throw new TransactionRuntimeException(e);
            }
            finally {
                this.runQueue.clear();
            }
        }

        @Override
        public void finallyRollbackIfNotCommitted() {
            if (!this.committed) {
                try {
                    this.rollback();
                }
                catch (TransactionRuntimeException transactionRuntimeException) {
                    // empty catch block
                }
            }
        }

        @Override
        public boolean isNewTransaction() {
            return true;
        }
    }

    private static class JoinedTransaction
    implements Transaction {
        private final NestedConnection nestedConnection;
        private final RunnablesQueue runQueue;
        private boolean committed = false;

        private JoinedTransaction(NestedConnection nestedConnection, RunnablesQueue runQueue) {
            this.nestedConnection = nestedConnection;
            this.runQueue = runQueue;
        }

        @Override
        public void runAfterSuccessfulCommit(@Nonnull Runnable runnable) {
            this.runQueue.offer(runnable);
        }

        @Override
        public NestedConnection getNestedConnection() {
            return this.nestedConnection;
        }

        @Override
        public void commit() {
            this.committed = true;
        }

        @Override
        public void rollback() throws TransactionRuntimeException {
            if (this.committed) {
                throw new IllegalStateException("The transaction has already been committed and hence you cannot rollback");
            }
            try {
                CoreTransactionUtil.setRollbackOnly(false);
            }
            catch (GenericTransactionException e) {
                log.error("Unable to rollback transaction : " + e.getMessage(), (Throwable)e);
                throw new TransactionRuntimeException(e);
            }
        }

        @Override
        public void finallyRollbackIfNotCommitted() {
            if (!this.committed) {
                try {
                    this.rollback();
                }
                catch (TransactionRuntimeException transactionRuntimeException) {
                    // empty catch block
                }
            }
        }

        @Override
        public boolean isNewTransaction() {
            return false;
        }
    }
}

