/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade;

import com.atlassian.jira.config.properties.PropertiesManager;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.upgrade.core.LegacyUpgradeTaskBuildNumberStorage;
import com.opensymphony.module.propertyset.PropertySet;
import java.util.Optional;
import javax.annotation.Nonnull;

public class LegacyUpgradeTaskBuildNumberStorageImpl
extends LegacyUpgradeTaskBuildNumberStorage {
    private final PropertiesManager propertiesManager;

    public LegacyUpgradeTaskBuildNumberStorageImpl(PropertiesManager propertiesManager) {
        this.propertiesManager = propertiesManager;
    }

    @Nonnull
    protected Optional<Integer> getIntegerPluginSetting(String key) {
        Assertions.notNull((String)"key", (Object)key);
        PropertySet propertySet = this.propertiesManager.getPropertySet();
        if (!propertySet.exists(key)) {
            return Optional.empty();
        }
        return Optional.ofNullable(switch (propertySet.getType(key)) {
            case 5 -> propertySet.getString(key);
            case 6 -> propertySet.getText(key);
            default -> null;
        }).map(Integer::valueOf);
    }

    protected void putIntegerPluginSetting(String key, int i) {
        Assertions.notNull((String)"key", (Object)key);
        PropertySet propertySet = this.propertiesManager.getPropertySet();
        if (propertySet.exists(key)) {
            propertySet.remove(key);
        }
        propertySet.setString(key, String.valueOf(i));
    }
}

