/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade;

import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.core.util.ClassLoaderUtils;
import com.atlassian.jira.component.pico.ComponentManager;
import com.atlassian.jira.upgrade.UpgradeProvider;
import electric.xml.Document;
import electric.xml.Element;
import electric.xml.ParseException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;

public class XmlFileUpgradeProvider
implements UpgradeProvider {
    private static final String UPGRADE_XML_TYPE = "upgrade";
    private final String upgradesXmlFilePath;
    private static final Function<Element, String> getClassNameFromUpgradeTaskNode = node -> node.getElement("class").getTextString();

    public XmlFileUpgradeProvider() {
        this("upgrades.xml");
    }

    XmlFileUpgradeProvider(String upgradesXmlFilePath) {
        this.upgradesXmlFilePath = upgradesXmlFilePath;
    }

    @Override
    public <T> Collection<T> getUpgradeTasks() {
        return (Collection)this.findUpgradeTasks().stream().map(getClassNameFromUpgradeTaskNode).map(this::loadUpgradeTaskComponent).collect(CollectorsUtil.toImmutableList());
    }

    @Override
    public <T> Collection<T> getUpgradeTasksBoundByBuild(long buildNumberUpperBound) {
        return (Collection)this.findUpgradeTasks().stream().filter(XmlFileUpgradeProvider.isBuildNumberLessThanOrEqualTo(buildNumberUpperBound)).map(getClassNameFromUpgradeTaskNode).map(this::loadUpgradeTaskComponent).collect(CollectorsUtil.toImmutableList());
    }

    private Collection<Element> findUpgradeTasks() {
        ArrayList<Element> arrayList;
        block8: {
            InputStream is = this.getFileInputStream();
            try {
                Document doc = new Document(is);
                Element root = doc.getRoot();
                arrayList = Collections.list(root.getElements(UPGRADE_XML_TYPE));
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ParseException | IOException e) {
                    throw new RuntimeException("Error parsing tasks file '" + this.upgradesXmlFilePath + "'", e);
                }
            }
            is.close();
        }
        return arrayList;
    }

    private InputStream getFileInputStream() {
        return Optional.ofNullable(ClassLoaderUtils.getResourceAsStream((String)this.upgradesXmlFilePath, this.getClass())).orElseThrow(() -> new RuntimeException("Could not read upgrade file '" + this.upgradesXmlFilePath + "'"));
    }

    private <T> T loadUpgradeTaskComponent(String taskName) {
        try {
            Class componentClass = ClassLoaderUtils.loadClass((String)taskName, this.getClass());
            return ComponentManager.getInstance().loadComponent(componentClass, Collections.emptyList());
        }
        catch (ClassNotFoundException | RuntimeException e) {
            throw new RuntimeException("Failed to instantiate task: " + taskName, e);
        }
    }

    private static final Predicate<Element> isBuildNumberLessThanOrEqualTo(Long build) {
        return node -> Long.valueOf(node.getAttribute("build")) <= build;
    }
}

