/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.jira.config.CachingFeatureManager;
import com.atlassian.jira.database.QueryDslAccessor;
import com.atlassian.jira.model.querydsl.FeatureDTO;
import com.atlassian.jira.model.querydsl.QFeature;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.upgrade.api.UpgradeContext;
import com.atlassian.upgrade.spi.UpgradeTask;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.SQLQuery;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public abstract class AbstractDarkFeatureEnablementTask
implements UpgradeTask {
    private static final Logger log = LoggerFactory.getLogger(AbstractDarkFeatureEnablementTask.class);
    private static final String FEATURE_TYPE_SITE = "site";
    private final CachingFeatureManager featureManager;
    private final QueryDslAccessor queryDslAccessor;
    private final String featureKey;
    private final String name;

    AbstractDarkFeatureEnablementTask(CachingFeatureManager featureManager, QueryDslAccessor queryDslAccessor, String featureKey, String name) {
        this.featureManager = Objects.requireNonNull(featureManager);
        this.queryDslAccessor = Objects.requireNonNull(queryDslAccessor);
        this.featureKey = Assertions.notBlank((String)"Feature key is empty", (String)featureKey);
        this.name = Assertions.notBlank((String)"Name of feature is empty", (String)name);
    }

    public String getShortDescription() {
        return "Enabling feature " + this.name + " (key: " + this.featureKey + ")";
    }

    public void runUpgrade(UpgradeContext upgradeContext) {
        this.queryDslAccessor.execute(conn -> {
            Long featureId = (Long)((SQLQuery)((SQLQuery)((SQLQuery)conn.newSqlQuery().select(QFeature.FEATURE.id).from((Expression)QFeature.FEATURE)).where((Predicate)QFeature.FEATURE.featureName.eq((Object)this.featureKey))).limit(1L)).fetchOne();
            if (featureId == null) {
                log.debug("Feature Flag for " + this.name + "(key: " + this.featureKey + ") was not set. Enabling it now.");
                conn.insert(QFeature.FEATURE).populate(FeatureDTO.builder().featureName(this.featureKey).featureType(FEATURE_TYPE_SITE).userKey("").build()).executeWithId();
                this.featureManager.reset();
            } else {
                log.debug("Feature Flag for " + this.name + " (key: " + this.featureKey + ") was already set - no operation.");
            }
        });
    }
}

