/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.jira.database.DbConnection;
import com.atlassian.jira.database.QueryDslAccessor;
import com.atlassian.jira.model.querydsl.OSPropertyEntryDTO;
import com.atlassian.jira.model.querydsl.OSPropertyTextDTO;
import com.atlassian.jira.model.querydsl.QDraftWorkflow;
import com.atlassian.jira.model.querydsl.QOSPropertyEntry;
import com.atlassian.jira.model.querydsl.QOSPropertyText;
import com.atlassian.jira.model.querydsl.QWorkflow;
import com.atlassian.jira.upgrade.AbstractDelayableUpgradeTask;
import com.google.common.collect.Lists;
import com.google.common.hash.Hashing;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.SQLQuery;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMd5ToShaWorkflowMigrationUpgradeTask
extends AbstractDelayableUpgradeTask {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractMd5ToShaWorkflowMigrationUpgradeTask.class);
    private static final int READ_BATCH_SIZE = 100;
    private final QueryDslAccessor queryDslAccessor;

    protected AbstractMd5ToShaWorkflowMigrationUpgradeTask(QueryDslAccessor queryDslAccessor) {
        this.queryDslAccessor = queryDslAccessor;
    }

    protected abstract String getLayoutPropertyKeyPrefix();

    protected abstract String getDraftLayoutPropertyKeyPrefix();

    protected abstract String getLayoutPropertyNewKeyPrefix();

    protected abstract String getDraftLayoutPropertyNewKeyPrefix();

    protected abstract String processOldPropertyTextToNewValue(String var1) throws Exception;

    @Override
    public boolean isDowngradeTaskRequired() {
        return false;
    }

    @Override
    public void doUpgrade(boolean setupMode) {
        this.queryDslAccessor.executeQuery(con -> {
            this.processWorkflowLayouts(con);
            this.processWorkflowDraftLayouts(con);
            return null;
        });
    }

    private void processWorkflowLayouts(DbConnection con) {
        Map<String, OSPropertyEntryDTO> propertyEntriesByNameMd5 = this.getPropertyEntriesByNameMd5(con);
        Map<Long, OSPropertyTextDTO> propertyValues = this.getPropertyTextsById(con, propertyEntriesByNameMd5.values().stream().map(OSPropertyEntryDTO::getId).collect(Collectors.toList()));
        Set<String> workflowSha256NamesForLayoutsWithTheNewLayout = this.getWorkflowSha256NamesForLayoutsWithTheNewLayout(con);
        Map<String, String> md5ToSha256MapForAllWorkflows = this.getAllWorkflowNameMD5ToSha256(con);
        ArrayList<OSPropertyEntryDTO> propertyEntriesToInsert = new ArrayList<OSPropertyEntryDTO>();
        propertyEntriesByNameMd5.forEach((md5Name, value) -> {
            String sha256NameForThisProperty = (String)md5ToSha256MapForAllWorkflows.get(md5Name);
            if (sha256NameForThisProperty != null && !this.hasTheLayoutBeenTranslatedToV6(sha256NameForThisProperty, workflowSha256NamesForLayoutsWithTheNewLayout)) {
                propertyEntriesToInsert.add(this.cloneWithNewKey(this.getLayoutPropertyNewKeyPrefix() + sha256NameForThisProperty, (OSPropertyEntryDTO)value));
            }
        });
        if (propertyEntriesToInsert.isEmpty()) {
            return;
        }
        Map<String, Long> sha256NameToKeyOfTheNewPropertyEntry = this.storePropertyKeys(propertyEntriesToInsert, con);
        List<OSPropertyTextDTO> propertyTextsToInsert = this.getAllPropertyTextsToInsert(propertyEntriesByNameMd5, md5ToSha256MapForAllWorkflows, workflowSha256NamesForLayoutsWithTheNewLayout, sha256NameToKeyOfTheNewPropertyEntry, propertyValues, this.getLayoutPropertyNewKeyPrefix());
        this.storeAllPropertyTexts(propertyTextsToInsert, con);
    }

    private void processWorkflowDraftLayouts(DbConnection con) {
        Map<String, OSPropertyEntryDTO> draftPropertyEntriesByNameMd5 = this.getDraftPropertyEntriesByNameMd5(con);
        Map<Long, OSPropertyTextDTO> draftPropertyValuesById = this.getPropertyTextsById(con, draftPropertyEntriesByNameMd5.values().stream().map(OSPropertyEntryDTO::getId).collect(Collectors.toList()));
        Set<String> draftWorkflowSha256NamesForLayoutsWithTheNewLayout = this.getDraftWorkflowSha256NamesForLayoutsWithTheNewLayout(con);
        Map<String, String> md5ToSha256MapForDraftAllWorkflows = this.getAllDraftWorkflowNameMD5ToSha256(con);
        ArrayList<OSPropertyEntryDTO> propertyEntriesToInsert = new ArrayList<OSPropertyEntryDTO>();
        draftPropertyEntriesByNameMd5.forEach((md5Name, value) -> {
            String sha256NameForThisProperty = (String)md5ToSha256MapForDraftAllWorkflows.get(md5Name);
            if (sha256NameForThisProperty != null && !this.hasTheLayoutBeenTranslatedToV6(sha256NameForThisProperty, draftWorkflowSha256NamesForLayoutsWithTheNewLayout)) {
                propertyEntriesToInsert.add(this.cloneWithNewKey(this.getDraftLayoutPropertyNewKeyPrefix() + sha256NameForThisProperty, (OSPropertyEntryDTO)value));
            }
        });
        if (propertyEntriesToInsert.isEmpty()) {
            return;
        }
        Map<String, Long> sha256NameToKeyOfTheNewPropertyEntry = this.storePropertyKeys(propertyEntriesToInsert, con);
        List<OSPropertyTextDTO> propertyTextsToInsert = this.getAllPropertyTextsToInsert(draftPropertyEntriesByNameMd5, md5ToSha256MapForDraftAllWorkflows, draftWorkflowSha256NamesForLayoutsWithTheNewLayout, sha256NameToKeyOfTheNewPropertyEntry, draftPropertyValuesById, this.getDraftLayoutPropertyNewKeyPrefix());
        this.storeAllPropertyTexts(propertyTextsToInsert, con);
    }

    private void storeAllPropertyTexts(List<OSPropertyTextDTO> propertyTextsToInsert, DbConnection con) {
        propertyTextsToInsert.forEach(propertyText -> con.insert(QOSPropertyText.O_S_PROPERTY_TEXT).populate(propertyText).execute());
    }

    private List<OSPropertyTextDTO> getAllPropertyTextsToInsert(Map<String, OSPropertyEntryDTO> propertyEntriesByNameMd5, Map<String, String> md5ToSha256MapForAllWorkflows, Set<String> workflowSha256NamesForLayoutsWithTheNewLayout, Map<String, Long> sha256NameToKeyOfTheNewPropertyEntry, Map<Long, OSPropertyTextDTO> propertyValues, String newKeyPrefix) {
        ArrayList<OSPropertyTextDTO> propertyTextsToInsert = new ArrayList<OSPropertyTextDTO>();
        propertyEntriesByNameMd5.forEach((md5Name, oldPropertyEntry) -> {
            Long previousIdOfTheProperty;
            OSPropertyTextDTO oldPropertyText;
            String newKey;
            Long newId;
            String sha256NameForThisProperty = (String)md5ToSha256MapForAllWorkflows.get(md5Name);
            if (sha256NameForThisProperty != null && !this.hasTheLayoutBeenTranslatedToV6(sha256NameForThisProperty, workflowSha256NamesForLayoutsWithTheNewLayout) && (newId = (Long)sha256NameToKeyOfTheNewPropertyEntry.get(newKey = newKeyPrefix + sha256NameForThisProperty)) != null && (oldPropertyText = (OSPropertyTextDTO)propertyValues.get(previousIdOfTheProperty = oldPropertyEntry.getId())) != null) {
                String newPropertyTextValue = null;
                try {
                    newPropertyTextValue = this.processOldPropertyTextToNewValue(oldPropertyText.getValue());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (newPropertyTextValue != null) {
                    OSPropertyTextDTO propertyText = new OSPropertyTextDTO(newId, newPropertyTextValue);
                    propertyTextsToInsert.add(propertyText);
                }
            }
        });
        return propertyTextsToInsert;
    }

    private boolean hasTheLayoutBeenTranslatedToV6(String sha256OfWorkflowName, Set<String> listOfSha256Properties) {
        return listOfSha256Properties.contains(sha256OfWorkflowName);
    }

    private Map<String, OSPropertyEntryDTO> getPropertyEntriesByNameMd5(DbConnection con) {
        return this.getPropertyEntriesByKeyPrefix(con, this.getLayoutPropertyKeyPrefix());
    }

    private Map<String, OSPropertyEntryDTO> getDraftPropertyEntriesByNameMd5(DbConnection con) {
        return this.getPropertyEntriesByKeyPrefix(con, this.getDraftLayoutPropertyKeyPrefix());
    }

    private Map<String, OSPropertyEntryDTO> getPropertyEntriesByKeyPrefix(DbConnection con, String prefix) {
        HashMap<String, OSPropertyEntryDTO> propertyEntriesByNameHash = new HashMap<String, OSPropertyEntryDTO>();
        Long pageNum = 0L;
        Map<String, OSPropertyEntryDTO> propertyEntriesByNameHashBatch = this.getPropertyEntriesByKeyPrefix(con, prefix, pageNum);
        while (!propertyEntriesByNameHashBatch.isEmpty()) {
            propertyEntriesByNameHash.putAll(propertyEntriesByNameHashBatch);
            Long l = pageNum;
            pageNum = pageNum + 1L;
            propertyEntriesByNameHashBatch = this.getPropertyEntriesByKeyPrefix(con, prefix, l);
        }
        return propertyEntriesByNameHash;
    }

    private Map<String, OSPropertyEntryDTO> getPropertyEntriesByKeyPrefix(DbConnection con, String prefix, Long pageNum) {
        HashMap<String, OSPropertyEntryDTO> entries = new HashMap<String, OSPropertyEntryDTO>();
        ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)con.newSqlQuery().select((Expression)QOSPropertyEntry.O_S_PROPERTY_ENTRY).from((Expression)QOSPropertyEntry.O_S_PROPERTY_ENTRY)).where((Predicate)QOSPropertyEntry.O_S_PROPERTY_ENTRY.propertyKey.startsWith(prefix))).orderBy(QOSPropertyEntry.O_S_PROPERTY_ENTRY.id.asc())).limit(100L)).offset(pageNum * 100L)).fetch().forEach(propertyEntry -> entries.put(propertyEntry.getPropertyKey().replace(prefix, ""), (OSPropertyEntryDTO)propertyEntry));
        return entries;
    }

    private Map<Long, OSPropertyTextDTO> getPropertyTextsById(DbConnection con, List<Long> ids) {
        HashMap<Long, OSPropertyTextDTO> allPropertyTexts = new HashMap<Long, OSPropertyTextDTO>();
        Lists.partition(ids, (int)100).forEach(idBatch -> {
            Map<Long, OSPropertyTextDTO> propertyTextsByIdBatch = this.getPropertyTextsByIdStep(con, (List<Long>)idBatch);
            allPropertyTexts.putAll(propertyTextsByIdBatch);
        });
        return allPropertyTexts;
    }

    private Map<Long, OSPropertyTextDTO> getPropertyTextsByIdStep(DbConnection con, List<Long> ids) {
        return ((SQLQuery)((SQLQuery)con.newSqlQuery().select((Expression)QOSPropertyText.O_S_PROPERTY_TEXT).from((Expression)QOSPropertyText.O_S_PROPERTY_TEXT)).where((Predicate)QOSPropertyText.O_S_PROPERTY_TEXT.id.in(ids))).fetch().stream().collect(Collectors.toMap(OSPropertyTextDTO::getId, propertyEntry -> propertyEntry));
    }

    private Set<String> getWorkflowSha256NamesForLayoutsWithTheNewLayout(DbConnection con) {
        return this.getWorkflowHashWithKeyPrefix(con, this.getLayoutPropertyNewKeyPrefix());
    }

    private Set<String> getDraftWorkflowSha256NamesForLayoutsWithTheNewLayout(DbConnection con) {
        return this.getWorkflowHashWithKeyPrefix(con, this.getDraftLayoutPropertyNewKeyPrefix());
    }

    private Set<String> getWorkflowHashWithKeyPrefix(DbConnection con, String prefix) {
        return ((SQLQuery)((SQLQuery)con.newSqlQuery().select((Expression)QOSPropertyEntry.O_S_PROPERTY_ENTRY).from((Expression)QOSPropertyEntry.O_S_PROPERTY_ENTRY)).where((Predicate)QOSPropertyEntry.O_S_PROPERTY_ENTRY.propertyKey.startsWith(prefix))).fetch().stream().map(osPropertyEntryDTO -> osPropertyEntryDTO.getPropertyKey().replace(prefix, "")).collect(Collectors.toSet());
    }

    private Map<String, String> getAllWorkflowNameMD5ToSha256(DbConnection con) {
        HashMap<String, String> accumulatedValues = new HashMap<String, String>();
        Long page = 0L;
        Map<String, String> allWorkflowNameMD5ToSha256Step = this.getAllWorkflowNameMD5ToSha256Step(con, page);
        while (!allWorkflowNameMD5ToSha256Step.isEmpty()) {
            accumulatedValues.putAll(allWorkflowNameMD5ToSha256Step);
            Long l = page;
            page = page + 1L;
            allWorkflowNameMD5ToSha256Step = this.getAllWorkflowNameMD5ToSha256Step(con, l);
        }
        return accumulatedValues;
    }

    private Map<String, String> getAllWorkflowNameMD5ToSha256Step(DbConnection con, Long pageNum) {
        HashMap<String, String> names = new HashMap<String, String>();
        ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)con.newSqlQuery().select(new Expression[]{QWorkflow.WORKFLOW.id, QWorkflow.WORKFLOW.name}).from((Expression)QWorkflow.WORKFLOW)).orderBy(QWorkflow.WORKFLOW.id.asc())).offset(pageNum * 100L)).limit(100L)).fetch().forEach(tuple -> names.put(this.getMd5Of((String)tuple.get((Expression)QWorkflow.WORKFLOW.name)), this.get256ShaOf((String)tuple.get((Expression)QWorkflow.WORKFLOW.name))));
        return names;
    }

    private Map<String, String> getAllDraftWorkflowNameMD5ToSha256(DbConnection con) {
        HashMap<String, String> names = new HashMap<String, String>();
        ((SQLQuery)con.newSqlQuery().select(new Expression[]{QDraftWorkflow.DRAFT_WORKFLOW.id, QDraftWorkflow.DRAFT_WORKFLOW.parentname}).from((Expression)QDraftWorkflow.DRAFT_WORKFLOW)).fetch().forEach(tuple -> names.put(this.getMd5Of((String)tuple.get((Expression)QDraftWorkflow.DRAFT_WORKFLOW.parentname)), this.get256ShaOf((String)tuple.get((Expression)QDraftWorkflow.DRAFT_WORKFLOW.parentname))));
        return names;
    }

    private String getMd5Of(String workflowName) {
        return DigestUtils.md5Hex((String)workflowName);
    }

    private Map<String, Long> storePropertyKeys(List<OSPropertyEntryDTO> propertyEntriesToInsert, DbConnection con) {
        HashMap<String, Long> propertyNewKeyToId = new HashMap<String, Long>();
        propertyEntriesToInsert.forEach(propertyEntry -> {
            Long propertyEntryId = con.insert(QOSPropertyEntry.O_S_PROPERTY_ENTRY).populate(propertyEntry).executeWithId();
            propertyNewKeyToId.put(propertyEntry.getPropertyKey(), propertyEntryId);
        });
        return propertyNewKeyToId;
    }

    private OSPropertyEntryDTO cloneWithNewKey(String newKey, OSPropertyEntryDTO dto) {
        return new OSPropertyEntryDTO(null, dto.getEntityName(), dto.getEntityId(), newKey, dto.getType());
    }

    private String get256ShaOf(String workflowName) {
        return Hashing.sha256().newHasher().putString((CharSequence)workflowName, StandardCharsets.UTF_8).hash().toString();
    }
}

