/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.jira.database.QueryDslAccessor;
import com.atlassian.jira.upgrade.tasks.AbstractMd5ToShaWorkflowMigrationUpgradeTask;
import com.atlassian.jira.upgrade.tasks.build10000002.layout.LayoutSerializer;
import com.atlassian.jira.upgrade.tasks.build10000002.layout.LegacyLayoutSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeTask_Build10000002
extends AbstractMd5ToShaWorkflowMigrationUpgradeTask {
    public static final int BUILD_NUMBER = 10000002;
    private static final Logger LOG = LoggerFactory.getLogger(UpgradeTask_Build10000002.class);
    private static final String LAYOUT_PROPERTY_KEY_PREFIX = "jira.workflow.layout:";
    private static final String LAYOUT_PROPERTY_NEW_KEY_PREFIX = "jira.workflow.layout.v6:";
    private static final String DRAFT_LAYOUT_PROPERTY_KEY_PREFIX = "jira.workflow.draft.layout:";
    private static final String DRAFT_LAYOUT_PROPERTY_NEW_KEY_PREFIX = "jira.workflow.draft.layout.v6:";
    private final LayoutSerializer layoutSerializer;
    private final LegacyLayoutSerializer legacyLayoutSerializer;

    public UpgradeTask_Build10000002(QueryDslAccessor queryDslAccessor, LayoutSerializer layoutSerializer, LegacyLayoutSerializer legacyLayoutSerializer) {
        super(queryDslAccessor);
        this.layoutSerializer = layoutSerializer;
        this.legacyLayoutSerializer = legacyLayoutSerializer;
    }

    @Override
    public int getBuildNumber() {
        return 10000002;
    }

    @Override
    public String getShortDescription() {
        return "Upgrade task to add a new SHA256 key to link workflows and its layout without using MD5 and the old workflow layout";
    }

    @Override
    public void doUpgrade(boolean setupMode) {
        super.doUpgrade(setupMode);
        LOG.info("Workflow layout upgrade from V1 to V3 succeeded");
    }

    @Override
    protected String getLayoutPropertyKeyPrefix() {
        return LAYOUT_PROPERTY_KEY_PREFIX;
    }

    @Override
    protected String getLayoutPropertyNewKeyPrefix() {
        return LAYOUT_PROPERTY_NEW_KEY_PREFIX;
    }

    @Override
    protected String getDraftLayoutPropertyKeyPrefix() {
        return DRAFT_LAYOUT_PROPERTY_KEY_PREFIX;
    }

    @Override
    protected String getDraftLayoutPropertyNewKeyPrefix() {
        return DRAFT_LAYOUT_PROPERTY_NEW_KEY_PREFIX;
    }

    @Override
    protected String processOldPropertyTextToNewValue(String oldPropertyTextValue) throws Exception {
        return this.layoutSerializer.serializeToJson(this.legacyLayoutSerializer.parse(oldPropertyTextValue));
    }
}

