/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.database.DbConnection;
import com.atlassian.jira.database.QueryDslAccessor;
import com.atlassian.jira.issue.fields.config.persistence.CachedFieldConfigSchemePersister;
import com.atlassian.jira.issue.fields.config.persistence.FieldConfigPersisterImpl;
import com.atlassian.jira.model.querydsl.ConfigurationContextDTO;
import com.atlassian.jira.model.querydsl.FieldConfigSchemeDTO;
import com.atlassian.jira.model.querydsl.FieldConfigSchemeIssueTypeDTO;
import com.atlassian.jira.model.querydsl.FieldConfigurationDTO;
import com.atlassian.jira.model.querydsl.GenericConfigurationDTO;
import com.atlassian.jira.model.querydsl.OSPropertyEntryDTO;
import com.atlassian.jira.model.querydsl.OSPropertyStringDTO;
import com.atlassian.jira.model.querydsl.OptionConfigurationDTO;
import com.atlassian.jira.model.querydsl.QConfigurationContext;
import com.atlassian.jira.model.querydsl.QFieldConfigScheme;
import com.atlassian.jira.model.querydsl.QFieldConfigSchemeIssueType;
import com.atlassian.jira.model.querydsl.QFieldConfiguration;
import com.atlassian.jira.model.querydsl.QGenericConfiguration;
import com.atlassian.jira.model.querydsl.QOSPropertyEntry;
import com.atlassian.jira.model.querydsl.QOSPropertyString;
import com.atlassian.jira.model.querydsl.QOptionConfiguration;
import com.atlassian.jira.model.querydsl.QPriority;
import com.atlassian.jira.upgrade.AbstractDelayableUpgradeTask;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeTask_Build76001
extends AbstractDelayableUpgradeTask {
    private static final Logger log = LoggerFactory.getLogger(UpgradeTask_Build76001.class);
    private static final String JIRA_CONSTANT_DEFAULT_PRIORITY = "jira.constant.default.priority";
    private static final String DEFAULT_PRIORITY_SCHEME = "jira.scheme.default.priority";
    private static final String PRIORITY_FIELD_ID = "priority";
    private static final Long JIRA_PROPERTIES_ENTITY_ID = 1L;
    private static final String JIRA_PROPERTIES_ENTITY_NAME = "jira.properties";
    private final QueryDslAccessor queryDslAccessor;

    public UpgradeTask_Build76001(QueryDslAccessor queryDslAccessor) {
        this.queryDslAccessor = queryDslAccessor;
    }

    @Override
    public int getBuildNumber() {
        return 76001;
    }

    @Override
    public String getShortDescription() {
        return "Creates default priority scheme containing all priorities on the instance";
    }

    @Override
    public boolean isDowngradeTaskRequired() {
        return false;
    }

    @Override
    public void doUpgrade(boolean setupMode) throws Exception {
        this.queryDslAccessor.execute(conn -> {
            log.debug("Adding default priority scheme with all priorities");
            this.doCleanupDefaultConfigAndScheme(conn);
            Long fieldConfigurationId = conn.insert(QFieldConfiguration.FIELD_CONFIGURATION).populate(FieldConfigurationDTO.builder().name("Default configuration for priority").description("Default configuration generated by JIRA").fieldid(PRIORITY_FIELD_ID).customfield(null).build()).executeWithId();
            Long configSchemeId = conn.insert(QFieldConfigScheme.FIELD_CONFIG_SCHEME).populate(FieldConfigSchemeDTO.builder().name("Default priority scheme").description("This is default priority scheme used by all projects without any other scheme assigned").fieldid(PRIORITY_FIELD_ID).customfield(null).build()).executeWithId();
            conn.insert(QFieldConfigSchemeIssueType.FIELD_CONFIG_SCHEME_ISSUE_TYPE).populate(FieldConfigSchemeIssueTypeDTO.builder().fieldconfigscheme(configSchemeId).fieldconfiguration(fieldConfigurationId).issuetype(null).build()).executeWithId();
            log.debug("Created FIELD_CONFIG_SCHEME_ISSUE_TYPE binding between FIELD_CONFIGURATION({}) and FIELD_CONFIG_SCHEME({})", (Object)fieldConfigurationId, (Object)configSchemeId);
            this.mapPrioritiesToFieldConfiguration(conn, fieldConfigurationId);
            this.mapDefaultPriority(conn, fieldConfigurationId);
            this.setSchemeAsDefault(conn, configSchemeId);
            this.invalidateCaches();
        });
    }

    private void invalidateCaches() {
        log.info("Invalidating FieldConfig caches");
        ((FieldConfigPersisterImpl)ComponentAccessor.getComponentOfType(FieldConfigPersisterImpl.class)).onClearCache(null);
        ((CachedFieldConfigSchemePersister)ComponentAccessor.getComponentOfType(CachedFieldConfigSchemePersister.class)).onClearCache(null);
    }

    private void mapPrioritiesToFieldConfiguration(DbConnection conn, Long fieldConfigurationId) {
        List priorities = ((SQLQuery)conn.newSqlQuery().select(new Expression[]{QPriority.PRIORITY.id, QPriority.PRIORITY.sequence}).from((Expression)QPriority.PRIORITY)).fetch();
        for (Tuple priority : priorities) {
            String priorityID = (String)priority.get(0, String.class);
            Long optionID = conn.insert(QOptionConfiguration.OPTION_CONFIGURATION).populate(OptionConfigurationDTO.builder().fieldconfig(fieldConfigurationId).fieldid(PRIORITY_FIELD_ID).optionid(priorityID).sequence((Long)priority.get(1, Long.class)).build()).executeWithId();
            log.debug("Added priority with ID {} as new option in default priority scheme({})", (Object)priorityID, (Object)optionID);
        }
    }

    private void mapDefaultPriority(DbConnection conn, Long fieldConfigurationId) {
        String defaultPriority = (String)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)conn.newSqlQuery().select((Expression)QOSPropertyString.O_S_PROPERTY_STRING.value).from((Expression)QOSPropertyEntry.O_S_PROPERTY_ENTRY)).join((EntityPath)QOSPropertyString.O_S_PROPERTY_STRING)).on((Predicate)QOSPropertyEntry.O_S_PROPERTY_ENTRY.id.eq(QOSPropertyString.O_S_PROPERTY_STRING.id))).where((Predicate)QOSPropertyEntry.O_S_PROPERTY_ENTRY.propertyKey.eq((Object)JIRA_CONSTANT_DEFAULT_PRIORITY).and((Predicate)QOSPropertyEntry.O_S_PROPERTY_ENTRY.entityId.eq((Object)JIRA_PROPERTIES_ENTITY_ID)).and((Predicate)QOSPropertyEntry.O_S_PROPERTY_ENTRY.entityName.eq((Object)JIRA_PROPERTIES_ENTITY_NAME)))).fetchFirst();
        if (StringUtils.isNotBlank((CharSequence)defaultPriority)) {
            conn.insert(QGenericConfiguration.GENERIC_CONFIGURATION).populate(GenericConfigurationDTO.builder().datatype("DefaultValue").datakey(String.valueOf(fieldConfigurationId)).xmlvalue(String.format("<string>%s</string>", defaultPriority))).executeWithId();
            log.debug("Added priority with ID {} as default priority in default scheme", (Object)defaultPriority);
        }
    }

    private void setSchemeAsDefault(DbConnection conn, Long configSchemeId) {
        Long propertyId = conn.insert(QOSPropertyEntry.O_S_PROPERTY_ENTRY).populate(OSPropertyEntryDTO.builder().entityName(JIRA_PROPERTIES_ENTITY_NAME).entityId(JIRA_PROPERTIES_ENTITY_ID).propertyKey(DEFAULT_PRIORITY_SCHEME).type(5)).executeWithId();
        conn.insert(QOSPropertyString.O_S_PROPERTY_STRING).populate(OSPropertyStringDTO.builder().id(propertyId).value(configSchemeId.toString())).execute();
        conn.insert(QConfigurationContext.CONFIGURATION_CONTEXT).populate(ConfigurationContextDTO.builder().projectcategory(null).project(null).key(PRIORITY_FIELD_ID).fieldconfigscheme(configSchemeId).build()).executeWithId();
        log.debug("Set priority scheme with ID {} as default scheme. New property ID: {}", (Object)configSchemeId, (Object)propertyId);
    }

    private void doCleanupDefaultConfigAndScheme(DbConnection conn) {
        Optional<Long> configSchemeId = Optional.ofNullable((Long)((SQLQuery)((SQLQuery)conn.newSqlQuery().select(QConfigurationContext.CONFIGURATION_CONTEXT.fieldconfigscheme).from((Expression)QConfigurationContext.CONFIGURATION_CONTEXT)).where((Predicate)QConfigurationContext.CONFIGURATION_CONTEXT.key.eq((Object)PRIORITY_FIELD_ID).and((Predicate)QConfigurationContext.CONFIGURATION_CONTEXT.project.isNull()).and((Predicate)QConfigurationContext.CONFIGURATION_CONTEXT.projectcategory.isNull()))).fetchFirst());
        if (configSchemeId.isPresent()) {
            conn.delete((RelationalPath<?>)QConfigurationContext.CONFIGURATION_CONTEXT).where((Predicate)QConfigurationContext.CONFIGURATION_CONTEXT.fieldconfigscheme.eq((Object)configSchemeId.get())).execute();
            Optional<Long> propertyId = Optional.ofNullable((Long)((SQLQuery)((SQLQuery)conn.newSqlQuery().select(QOSPropertyEntry.O_S_PROPERTY_ENTRY.id).from((Expression)QOSPropertyEntry.O_S_PROPERTY_ENTRY)).where((Predicate)QOSPropertyEntry.O_S_PROPERTY_ENTRY.entityId.eq((Object)JIRA_PROPERTIES_ENTITY_ID).and((Predicate)QOSPropertyEntry.O_S_PROPERTY_ENTRY.propertyKey.eq((Object)DEFAULT_PRIORITY_SCHEME)).and((Predicate)QOSPropertyEntry.O_S_PROPERTY_ENTRY.entityName.eq((Object)JIRA_PROPERTIES_ENTITY_NAME)))).fetchFirst());
            if (propertyId.isPresent()) {
                conn.delete((RelationalPath<?>)QOSPropertyString.O_S_PROPERTY_STRING).where((Predicate)QOSPropertyString.O_S_PROPERTY_STRING.id.eq((Object)propertyId.get())).execute();
                conn.delete((RelationalPath<?>)QOSPropertyEntry.O_S_PROPERTY_ENTRY).where((Predicate)QOSPropertyEntry.O_S_PROPERTY_ENTRY.id.eq((Object)propertyId.get())).execute();
            }
            Optional<Long> fieldConfigurationId = Optional.ofNullable((Long)((SQLQuery)((SQLQuery)conn.newSqlQuery().select(QFieldConfigSchemeIssueType.FIELD_CONFIG_SCHEME_ISSUE_TYPE.fieldconfiguration).from((Expression)QFieldConfigSchemeIssueType.FIELD_CONFIG_SCHEME_ISSUE_TYPE)).where((Predicate)QFieldConfigSchemeIssueType.FIELD_CONFIG_SCHEME_ISSUE_TYPE.fieldconfigscheme.eq((Object)configSchemeId.get()))).fetchFirst());
            conn.delete((RelationalPath<?>)QFieldConfigSchemeIssueType.FIELD_CONFIG_SCHEME_ISSUE_TYPE).where((Predicate)QFieldConfigSchemeIssueType.FIELD_CONFIG_SCHEME_ISSUE_TYPE.fieldconfigscheme.eq((Object)configSchemeId.get())).execute();
            if (fieldConfigurationId.isPresent()) {
                conn.delete((RelationalPath<?>)QGenericConfiguration.GENERIC_CONFIGURATION).where((Predicate)QGenericConfiguration.GENERIC_CONFIGURATION.datatype.eq((Object)"DefaultValue").and((Predicate)QGenericConfiguration.GENERIC_CONFIGURATION.datakey.eq((Object)String.valueOf(fieldConfigurationId.get())))).execute();
                conn.delete((RelationalPath<?>)QOptionConfiguration.OPTION_CONFIGURATION).where((Predicate)QOptionConfiguration.OPTION_CONFIGURATION.fieldconfig.eq((Object)fieldConfigurationId.get())).execute();
                conn.delete((RelationalPath<?>)QFieldConfiguration.FIELD_CONFIGURATION).where((Predicate)QFieldConfiguration.FIELD_CONFIGURATION.id.eq((Object)fieldConfigurationId.get())).execute();
            }
            conn.delete((RelationalPath<?>)QFieldConfigScheme.FIELD_CONFIG_SCHEME).where((Predicate)QFieldConfigScheme.FIELD_CONFIG_SCHEME.id.eq((Object)configSchemeId.get())).execute();
        }
    }
}

