/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.jira.cache.request.RequestCacheController;
import com.atlassian.jira.project.DefaultProjectManager;
import com.atlassian.jira.project.ProjectPropertiesManager;
import com.atlassian.jira.upgrade.AbstractDelayableUpgradeTask;
import com.opensymphony.module.propertyset.PropertySet;
import java.util.Date;

public class UpgradeTask_Build804000
extends AbstractDelayableUpgradeTask {
    private static final String ARCHIVED_DATE_KEY = "jira.archiving.projects.date";
    private static final String ARCHIVED_TIMESTAMP_KEY = "jira.archiving.projects.timestamp";
    private final DefaultProjectManager projectManager;
    private final ProjectPropertiesManager propertiesManager;

    public UpgradeTask_Build804000(DefaultProjectManager defaultProjectManager, ProjectPropertiesManager propertiesManager) {
        this.projectManager = defaultProjectManager;
        this.propertiesManager = propertiesManager;
    }

    @Override
    public int getBuildNumber() {
        return 804000;
    }

    @Override
    public String getShortDescription() {
        return "Converts timestamp of an archived project from the 'propertynumber' table to date and moves it to the 'propertydate' table.";
    }

    @Override
    public void doUpgrade(boolean setupMode) throws Exception {
        this.clearRequestCaches();
        this.projectManager.getArchivedProjects().forEach(p -> {
            PropertySet propertySet = this.propertiesManager.getPropertySet(p);
            if (propertySet.getKeys().contains(ARCHIVED_TIMESTAMP_KEY)) {
                long timestamp = propertySet.getLong(ARCHIVED_TIMESTAMP_KEY);
                propertySet.setDate(ARCHIVED_DATE_KEY, new Date(timestamp));
                propertySet.remove(ARCHIVED_TIMESTAMP_KEY);
            }
        });
    }

    private void clearRequestCaches() {
        RequestCacheController.clearAll();
    }

    @Override
    public boolean isDowngradeTaskRequired() {
        return false;
    }
}

