/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.jira.database.QueryDslAccessor;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.model.querydsl.QDirectoryAttribute;
import com.atlassian.jira.upgrade.AbstractDelayableUpgradeTask;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.RelationalPath;
import java.sql.SQLException;
import java.sql.Statement;
import javax.annotation.Nonnull;

public class UpgradeTask_Build811001
extends AbstractDelayableUpgradeTask {
    private final QueryDslAccessor queryDslAccessor;

    public UpgradeTask_Build811001(QueryDslAccessor queryDslAccessor) {
        this.queryDslAccessor = queryDslAccessor;
    }

    @Override
    public int getBuildNumber() {
        return 811001;
    }

    @Override
    @Nonnull
    public String getShortDescription() {
        return "Embedded Crowd upgrade task - promote CWD_DIRECTORY_ATTRIBUTE.ATTRIBUTE_VALUE";
    }

    @Override
    public void doUpgrade(boolean setupMode) throws Exception {
        this.queryDslAccessor.execute(callback -> callback.delete((RelationalPath<?>)QDirectoryAttribute.DIRECTORY_ATTRIBUTE).where((Predicate)QDirectoryAttribute.DIRECTORY_ATTRIBUTE.value.isNull()).execute());
        if (this.isORACLE()) {
            this.recreateColumnForOracle("CWD_DIRECTORY_ATTRIBUTE", "ATTRIBUTE_VALUE", "ATTRIBUTE_VALUE_TMP", "CLOB");
        }
    }

    private void recreateColumnForOracle(String tableName, String columnName, String tmpColumnName, String columnType) {
        this.queryDslAccessor.execute(callback -> {
            try (Statement statement = callback.getJdbcConnection().createStatement();){
                statement.execute(String.format("ALTER TABLE %s ADD %s %s", tableName, tmpColumnName, columnType));
                statement.execute(String.format("UPDATE %s SET %s = %s", tableName, tmpColumnName, columnName));
                statement.execute(String.format("ALTER TABLE %s DROP COLUMN %s", tableName, columnName));
                statement.execute(String.format("ALTER TABLE %s RENAME COLUMN %s TO %s", tableName, tmpColumnName, columnName));
            }
            catch (SQLException e) {
                throw new DataAccessException((Throwable)e);
            }
        });
    }

    @Override
    public boolean isDowngradeTaskRequired() {
        return false;
    }
}

