/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.jira.database.QueryDslAccessor;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.model.querydsl.MembershipDTO;
import com.atlassian.jira.model.querydsl.QMembership;
import com.atlassian.jira.upgrade.AbstractDelayableUpgradeTask;
import com.atlassian.jira.upgrade.DropIndexHelper;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.ofbiz.core.entity.DelegatorInterface;
import org.ofbiz.core.entity.model.ModelEntity;
import org.ofbiz.core.entity.model.ModelIndex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeTask_Build822000
extends AbstractDelayableUpgradeTask {
    private static final Logger log = LoggerFactory.getLogger(UpgradeTask_Build822000.class);
    private static final String TABLE_NAME_CWD_MEMBERSHIP = QMembership.MEMBERSHIP.getTableName();
    private static final String INDEX_NAME_UK_MEM_DIR_PARENT_CHILD = "uk_mem_dir_parent_child";
    private static final String INDEX_NAME_UK_MEM_PARENT_CHILD_TYPE = "uk_mem_parent_child_type";
    private static final String INDEX_NAME_IDX_MEM_DIR_PARENT_CHILD = "idx_mem_dir_parent_child";
    private final QueryDslAccessor queryDslAccessor;
    private final DelegatorInterface delegatorInterface;
    private final DropIndexHelper dropIndexHelper;

    public UpgradeTask_Build822000(QueryDslAccessor queryDslAccessor, DelegatorInterface delegatorInterface) {
        this.queryDslAccessor = queryDslAccessor;
        this.delegatorInterface = delegatorInterface;
        this.dropIndexHelper = new DropIndexHelper(this);
    }

    @Override
    public int getBuildNumber() {
        return 822000;
    }

    @Override
    public String getShortDescription() {
        return "Drops the 'uk_mem_parent_child_type' and 'idx_mem_dir_parent_child' indexes from the '" + TABLE_NAME_CWD_MEMBERSHIP + "' table. Removes duplicates in '" + TABLE_NAME_CWD_MEMBERSHIP + "'. Creates 'uk_mem_dir_parent_child' index if it doesn't exist.";
    }

    @Override
    public boolean isDowngradeTaskRequired() {
        return true;
    }

    @Override
    public void doUpgrade(boolean setupMode) throws Exception {
        this.dropOldIndexes();
        Set<String> existingIndexes = this.getExistingMembershipIndexes();
        log.debug("Existing {} indexes: {}", (Object)TABLE_NAME_CWD_MEMBERSHIP, existingIndexes);
        if (!existingIndexes.contains(INDEX_NAME_UK_MEM_DIR_PARENT_CHILD)) {
            log.info("Index {} is missing", (Object)INDEX_NAME_UK_MEM_DIR_PARENT_CHILD);
            this.removeDuplicateMemberships();
            this.addUkMemDirParentChildIndex();
        } else {
            log.info("Index {} is present, nothing to do.", (Object)INDEX_NAME_UK_MEM_DIR_PARENT_CHILD);
        }
    }

    private Set<String> getExistingMembershipIndexes() {
        ArrayList messages = new ArrayList();
        Map indexInfo = this.getDatabaseUtil().getIndexInfo((Set)ImmutableSet.of((Object)TABLE_NAME_CWD_MEMBERSHIP), messages, true);
        if (!messages.isEmpty()) {
            throw new DataAccessException(String.join((CharSequence)" ", messages));
        }
        Set existingIndexes = (Set)indexInfo.get(TABLE_NAME_CWD_MEMBERSHIP);
        return existingIndexes.stream().map(String::toLowerCase).collect(Collectors.toSet());
    }

    private void removeDuplicateMemberships() {
        QMembership duplicateMembership = new QMembership("DUPLICATE");
        List duplicateMemberships = this.queryDslAccessor.executeQuery(connection -> ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)connection.newSqlQuery().select((Expression)QMembership.MEMBERSHIP).from((Expression)QMembership.MEMBERSHIP)).join((EntityPath)duplicateMembership)).on(new Predicate[]{duplicateMembership.lowerParentName.eq((Expression)QMembership.MEMBERSHIP.lowerParentName), duplicateMembership.lowerChildName.eq((Expression)QMembership.MEMBERSHIP.lowerChildName), duplicateMembership.membershipType.eq((Expression)QMembership.MEMBERSHIP.membershipType), duplicateMembership.directoryId.eq(QMembership.MEMBERSHIP.directoryId), duplicateMembership.id.ne(QMembership.MEMBERSHIP.id)})).distinct()).fetch());
        Map<MembershipUniqueIdentifier, List> groupedMemberships = duplicateMemberships.stream().collect(Collectors.groupingBy(MembershipUniqueIdentifier::new, Collectors.toCollection(ArrayList::new)));
        groupedMemberships.values().forEach(l -> l.sort(Comparator.comparing(MembershipDTO::getId).reversed()));
        log.info("Detected duplicate memberships in DB. There are {} rows representing {} unique memberships", (Object)duplicateMemberships.size(), (Object)groupedMemberships.size());
        int rowsToDelete = duplicateMemberships.size() - groupedMemberships.size();
        long deletedRows = 0L;
        for (List listWithDuplicates : groupedMemberships.values()) {
            MembershipDTO itemToRemainInDb = (MembershipDTO)listWithDuplicates.remove(0);
            log.info("({} of {}) Leaving membership {} and removed its duplicate(s): {}", new Object[]{deletedRows += this.queryDslAccessor.executeQuery(dbConnection -> dbConnection.delete((RelationalPath<?>)QMembership.MEMBERSHIP).where((Predicate)QMembership.MEMBERSHIP.id.in((Collection)Lists.transform((List)listWithDuplicates, MembershipDTO::getId))).execute()).longValue(), rowsToDelete, this.dtoToString(itemToRemainInDb), Lists.transform((List)listWithDuplicates, this::dtoToString)});
        }
        log.info("Removed {} duplicate rows", (Object)deletedRows);
    }

    private String dtoToString(MembershipDTO membershipDTO) {
        return "Membership{id=" + membershipDTO.getId() + ", parentId=" + membershipDTO.getParentId() + ", childId=" + membershipDTO.getChildId() + ", membershipType='" + membershipDTO.getMembershipType() + "', groupType='" + membershipDTO.getGroupType() + "', parentName='" + membershipDTO.getParentName() + "', lowerParentName='" + membershipDTO.getLowerParentName() + "', childName='" + membershipDTO.getChildName() + "', lowerChildName='" + membershipDTO.getLowerChildName() + "', directoryId=" + membershipDTO.getDirectoryId() + "}";
    }

    private void addUkMemDirParentChildIndex() {
        log.info("Adding index {}", (Object)INDEX_NAME_UK_MEM_DIR_PARENT_CHILD);
        ModelEntity membershipModelEntity = this.delegatorInterface.getModelEntity(QMembership.MEMBERSHIP.getEntityName());
        ModelIndex ukMemDirParentChildModelIndex = membershipModelEntity.getIndex(INDEX_NAME_UK_MEM_DIR_PARENT_CHILD);
        this.getDatabaseUtil().createDeclaredIndex(membershipModelEntity, ukMemDirParentChildModelIndex);
        log.info("Added index {}", (Object)INDEX_NAME_UK_MEM_DIR_PARENT_CHILD);
    }

    private void dropOldIndexes() throws SQLException {
        this.dropIndex(INDEX_NAME_UK_MEM_PARENT_CHILD_TYPE);
        this.dropIndex(INDEX_NAME_IDX_MEM_DIR_PARENT_CHILD);
    }

    private void dropIndex(String indexName) throws SQLException {
        log.info("Dropping index {}", (Object)indexName);
        this.dropIndexHelper.dropIndex(TABLE_NAME_CWD_MEMBERSHIP, indexName);
        log.info("Dropped index {}", (Object)indexName);
    }

    private static final class MembershipUniqueIdentifier {
        final String lowerParentName;
        final String lowerChildName;
        final String membershipType;
        final long directoryId;

        public MembershipUniqueIdentifier(MembershipDTO membershipDTO) {
            this.lowerParentName = membershipDTO.getLowerParentName();
            this.lowerChildName = membershipDTO.getLowerChildName();
            this.membershipType = membershipDTO.getMembershipType();
            this.directoryId = membershipDTO.getDirectoryId();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MembershipUniqueIdentifier that = (MembershipUniqueIdentifier)o;
            return this.directoryId == that.directoryId && this.lowerParentName.equals(that.lowerParentName) && this.lowerChildName.equals(that.lowerChildName) && this.membershipType.equals(that.membershipType);
        }

        public int hashCode() {
            return Objects.hash(this.lowerParentName, this.lowerChildName, this.membershipType, this.directoryId);
        }

        public String toString() {
            return "MembershipUniqueIdentifier{lowerParentName='" + this.lowerParentName + "', lowerChildName='" + this.lowerChildName + "', membershipType='" + this.membershipType + "', directoryId=" + this.directoryId + "}";
        }
    }
}

