/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.jira.database.DatabaseAccessor;
import com.atlassian.jira.database.DatabaseVendor;
import com.atlassian.jira.database.QueryDslAccessor;
import com.atlassian.jira.model.querydsl.JiraRelationalPathBase;
import com.atlassian.jira.model.querydsl.QOSPropertyEntry;
import com.atlassian.jira.propertyset.OfBizPropertyTypeRegistry;
import com.atlassian.jira.upgrade.AbstractDelayableUpgradeTask;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.core.types.dsl.PathBuilder;
import com.querydsl.core.types.dsl.SimpleExpression;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLExpressions;
import com.querydsl.sql.SQLQuery;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.ofbiz.core.entity.DelegatorInterface;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.jdbc.DatabaseUtil;
import org.ofbiz.core.entity.model.ModelEntity;
import org.ofbiz.core.entity.model.ModelIndex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeTask_Build9150000
extends AbstractDelayableUpgradeTask {
    private static final Logger LOG = LoggerFactory.getLogger(UpgradeTask_Build9150000.class);
    private final DelegatorInterface delegatorInterface;
    private final QueryDslAccessor queryDslAccessor;
    private final DatabaseAccessor databaseAccessor;

    public UpgradeTask_Build9150000(DelegatorInterface delegatorInterface, QueryDslAccessor queryDslAccessor, DatabaseAccessor databaseAccessor) {
        this.delegatorInterface = delegatorInterface;
        this.queryDslAccessor = queryDslAccessor;
        this.databaseAccessor = databaseAccessor;
    }

    @Override
    public int getBuildNumber() {
        return 9150000;
    }

    @Override
    public String getShortDescription() {
        return "Adds a unique constraint to propertyentry table after making sure the table is properly de-duplicated.";
    }

    @Override
    public boolean isDowngradeTaskRequired() {
        return true;
    }

    @Override
    public void doUpgrade(boolean setupMode) throws Exception {
        AtomicLong deletedEntries = new AtomicLong();
        AtomicLong deletedValues = new AtomicLong();
        this.queryDslAccessor.withNewConnection().execute(conn -> {
            conn.setAutoCommit(false);
            deletedEntries.set(conn.delete((RelationalPath<?>)QOSPropertyEntry.O_S_PROPERTY_ENTRY).where((Predicate)QOSPropertyEntry.O_S_PROPERTY_ENTRY.id.in(this.getDuplicatePropertyEntriesQuery())).execute());
            this.getValueTableToTypesMapping().forEach((table, types) -> deletedValues.addAndGet(conn.delete((RelationalPath<?>)table).where((Predicate)table.getNumericIdPath().in(this.getOrphanedPropertyValuesQuery((JiraRelationalPathBase<?>)((Object)((Object)table)), (Collection<Integer>)types))).execute()));
            conn.commit();
        });
        if (deletedEntries.get() > 0L) {
            LOG.info("Deleted {} stale property set entries that were duplicates of the latest entry for each (entityName, entityId, propertyKey) tuple.", (Object)deletedEntries.get());
        }
        if (deletedValues.get() > 0L) {
            LOG.info("Deleted {} stale property set values that were duplicates of the latest entry for each (entityName, entityId, propertyKey) tuple.", (Object)deletedValues.get());
        }
        this.recreateIndexes();
    }

    private SQLQuery<Long> getDuplicatePropertyEntriesQuery() {
        SQLQuery selectEntryId;
        QOSPropertyEntry latestPropertyHavingDuplicatesAlias = new QOSPropertyEntry("latest_property_having_duplicates");
        PathBuilder latestIdPath = new PathBuilder(Long.class, "latest_id");
        SQLQuery latestPropertiesHavingDuplicatesQuery = (SQLQuery)((SQLQuery)((SQLQuery)SQLExpressions.select((Expression[])new Expression[]{QOSPropertyEntry.O_S_PROPERTY_ENTRY.id.max().as((Path)latestIdPath), QOSPropertyEntry.O_S_PROPERTY_ENTRY.entityName, QOSPropertyEntry.O_S_PROPERTY_ENTRY.entityId, QOSPropertyEntry.O_S_PROPERTY_ENTRY.propertyKey}).from((Expression)QOSPropertyEntry.O_S_PROPERTY_ENTRY)).groupBy(new Expression[]{QOSPropertyEntry.O_S_PROPERTY_ENTRY.entityName, QOSPropertyEntry.O_S_PROPERTY_ENTRY.entityId, QOSPropertyEntry.O_S_PROPERTY_ENTRY.propertyKey})).having((Predicate)QOSPropertyEntry.O_S_PROPERTY_ENTRY.id.count().gt((Number)1));
        if (this.databaseAccessor.getDatabaseVendor().equals((Object)DatabaseVendor.MY_SQL)) {
            QOSPropertyEntry preload = new QOSPropertyEntry("preload");
            selectEntryId = (SQLQuery)((SQLQuery)SQLExpressions.select(preload.id).with((Path)preload, (SubQueryExpression)SQLExpressions.select((Expression[])new Expression[]{QOSPropertyEntry.O_S_PROPERTY_ENTRY.id, QOSPropertyEntry.O_S_PROPERTY_ENTRY.entityName, QOSPropertyEntry.O_S_PROPERTY_ENTRY.entityId, QOSPropertyEntry.O_S_PROPERTY_ENTRY.propertyKey}).from((Expression)QOSPropertyEntry.O_S_PROPERTY_ENTRY))).from((Expression)preload);
        } else {
            selectEntryId = (SQLQuery)SQLExpressions.select(QOSPropertyEntry.O_S_PROPERTY_ENTRY.id).from((Expression)QOSPropertyEntry.O_S_PROPERTY_ENTRY);
        }
        return (SQLQuery)((SQLQuery)((SQLQuery)selectEntryId.innerJoin((SubQueryExpression)latestPropertiesHavingDuplicatesQuery, (Path)latestPropertyHavingDuplicatesAlias)).on(new Predicate[]{latestPropertyHavingDuplicatesAlias.entityName.eq((Expression)QOSPropertyEntry.O_S_PROPERTY_ENTRY.entityName), latestPropertyHavingDuplicatesAlias.entityId.eq(QOSPropertyEntry.O_S_PROPERTY_ENTRY.entityId), latestPropertyHavingDuplicatesAlias.propertyKey.eq((Expression)QOSPropertyEntry.O_S_PROPERTY_ENTRY.propertyKey)})).where((Predicate)QOSPropertyEntry.O_S_PROPERTY_ENTRY.id.ne((Expression)latestIdPath));
    }

    private SQLQuery<Long> getOrphanedPropertyValuesQuery(JiraRelationalPathBase<?> pathBase, Collection<Integer> typeIds) {
        SQLQuery selectValueId;
        if (this.databaseAccessor.getDatabaseVendor().equals((Object)DatabaseVendor.MY_SQL)) {
            SimpleExpression preloadQueryForValueTable = ((SQLQuery)SQLExpressions.select(pathBase.getNumericIdPath()).from(pathBase)).as(pathBase);
            selectValueId = (SQLQuery)SQLExpressions.select(pathBase.getNumericIdPath()).from((Expression)preloadQueryForValueTable);
        } else {
            selectValueId = (SQLQuery)SQLExpressions.select(pathBase.getNumericIdPath()).from(pathBase);
        }
        return (SQLQuery)((SQLQuery)((SQLQuery)selectValueId.leftJoin((EntityPath)QOSPropertyEntry.O_S_PROPERTY_ENTRY)).on((Predicate)QOSPropertyEntry.O_S_PROPERTY_ENTRY.id.eq(pathBase.getNumericIdPath()))).where((Predicate)QOSPropertyEntry.O_S_PROPERTY_ENTRY.id.isNull().or((Predicate)QOSPropertyEntry.O_S_PROPERTY_ENTRY.type.notIn(typeIds)));
    }

    private Map<? extends JiraRelationalPathBase<?>, List<Integer>> getValueTableToTypesMapping() {
        return OfBizPropertyTypeRegistry.TYPE_MAPPER.entrySet().stream().collect(Collectors.groupingBy(entry -> ((OfBizPropertyTypeRegistry.TypeMapper)entry.getValue()).getValueTable(), Collectors.mapping(Map.Entry::getKey, Collectors.toList())));
    }

    private void recreateIndexes() throws GenericEntityException {
        String entityName = QOSPropertyEntry.O_S_PROPERTY_ENTRY.getEntityName();
        String helperName = this.delegatorInterface.getEntityHelper(entityName).getHelperName();
        DatabaseUtil dbUtil = new DatabaseUtil(helperName);
        ModelEntity modelEntity = this.delegatorInterface.getModelEntity(entityName);
        ModelIndex index = modelEntity.getIndex("osproperty_entId_name_propKey");
        dbUtil.deleteDeclaredIndex(modelEntity, index);
        dbUtil.createDeclaredIndex(modelEntity, index);
    }
}

