/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks.build10000002.layout;

import com.atlassian.jira.upgrade.tasks.build10000002.layout.IdUtils;
import com.atlassian.jira.upgrade.tasks.build10000002.layout.LayoutSerializationException;
import com.atlassian.jira.upgrade.tasks.build10000002.layout.stored.StoredLayout;
import com.atlassian.jira.upgrade.tasks.build10000002.layout.stored.StoredStatus;
import com.atlassian.jira.upgrade.tasks.build10000002.utilities.JsonSerializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class LegacyLayoutSerializer {
    private final JsonSerializer serializer;

    @Autowired
    public LegacyLayoutSerializer(JsonSerializer serializer) {
        this.serializer = serializer;
    }

    public StoredLayout parse(String legacyLayoutJson) throws LayoutSerializationException {
        HashSet statuses = Sets.newHashSet();
        JsonNode root = this.serializer.readTree(legacyLayoutJson);
        JsonNode nodeMap = root.get("nodeMap");
        Iterator statusNodes = nodeMap.fields();
        while (statusNodes.hasNext()) {
            Map.Entry statusEntry = (Map.Entry)statusNodes.next();
            JsonNode statusNode = (JsonNode)statusEntry.getValue();
            boolean initial = statusNode.get("isInitialAction").asBoolean();
            int stepId = statusNode.get("stepId").asInt();
            JsonNode rectNode = statusNode.get("rect");
            double x = rectNode.get("x").asDouble();
            double y = rectNode.get("y").asDouble();
            String id = IdUtils.statusUID(stepId, initial);
            statuses.add(new StoredStatus(id, x, y));
        }
        return new StoredLayout(statuses, Sets.newHashSet(), null, null, null);
    }
}

