/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks.build10000002.utilities;

import com.atlassian.jira.upgrade.tasks.build10000002.layout.LayoutSerializationException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.springframework.stereotype.Component;

@Component
public class JsonSerializer {
    public String serialize(Object object) throws LayoutSerializationException {
        try {
            return new ObjectMapper().writeValueAsString(object);
        }
        catch (IOException e) {
            throw new LayoutSerializationException(e);
        }
    }

    public <T> T deserialize(String json, Class<T> type) throws LayoutSerializationException {
        try {
            return (T)new ObjectMapper().readValue(json, type);
        }
        catch (IOException e) {
            throw new LayoutSerializationException(e);
        }
    }

    public JsonNode readTree(String json) throws LayoutSerializationException {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return mapper.readTree(json);
        }
        catch (IOException e) {
            throw new LayoutSerializationException(e);
        }
    }
}

