/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks.role;

import com.atlassian.application.api.ApplicationKey;
import com.atlassian.jira.upgrade.tasks.role.License;
import com.atlassian.jira.upgrade.tasks.role.MigrationFailedException;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.atlassian.fugue.Option;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import javax.annotation.Nullable;

public final class Licenses {
    private final ImmutableMap<ApplicationKey, License> index;
    private final ImmutableSet<License> licenses;

    public Licenses(Iterable<? extends License> licenses) {
        Assertions.containsNoNulls((String)"licenses", licenses);
        HashMap<ApplicationKey, License> index = new HashMap<ApplicationKey, License>();
        for (License license : licenses) {
            for (ApplicationKey applicationKey : license.applicationKeys()) {
                License oldLicense = index.put(applicationKey, license);
                if (oldLicense == null || oldLicense.equals(license)) continue;
                throw new MigrationFailedException(String.format("More than once license contains access to '%s'. The licenses are: %s and %s.", applicationKey, oldLicense, license));
            }
        }
        this.licenses = ImmutableSet.copyOf(licenses);
        this.index = ImmutableMap.copyOf(index);
    }

    private Licenses(ImmutableSet<License> licenses, ImmutableMap<ApplicationKey, License> index) {
        this.licenses = licenses;
        this.index = index;
    }

    public boolean isEmpty() {
        return this.licenses.isEmpty();
    }

    Set<License> get() {
        return this.licenses;
    }

    Set<ApplicationKey> keys() {
        return this.index.keySet();
    }

    Option<License> license(ApplicationKey applicationKey) {
        return Option.option((Object)((License)this.index.get((Object)applicationKey)));
    }

    boolean canAdd(License license) {
        Assertions.notNull((String)"license", (Object)license);
        return Collections.disjoint(license.applicationKeys(), this.keys());
    }

    public Licenses addLicense(License license) {
        Assertions.notNull((String)"license", (Object)license);
        if (this.licenses.contains((Object)license)) {
            return this;
        }
        ImmutableMap.Builder newIndex = ImmutableMap.builder().putAll(this.index);
        for (ApplicationKey applicationKey : license.applicationKeys()) {
            License oldLicense = (License)this.index.get((Object)applicationKey);
            if (oldLicense != null) {
                throw new MigrationFailedException(String.format("Current license already contains access to '%s'. The old license is: %s", applicationKey, oldLicense));
            }
            newIndex.put((Object)applicationKey, (Object)license);
        }
        ImmutableSet licenses = ImmutableSet.builder().addAll(this.licenses).add((Object)license).build();
        return new Licenses((ImmutableSet<License>)licenses, (ImmutableMap<ApplicationKey, License>)newIndex.build());
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Licenses otherLicenses = (Licenses)o;
        return this.licenses.equals(otherLicenses.licenses);
    }

    public int hashCode() {
        return this.licenses.hashCode();
    }

    public String toString() {
        return this.licenses.toString();
    }
}

