/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks.util;

import java.time.Duration;
import org.slf4j.Logger;

public final class Monitoring {
    private Monitoring() {
    }

    public static Thread startWatchdogThreadForCurrentThread(String watchdogThreadName, Duration interval, Logger log, String message) {
        Thread upgradeTaskThread = Thread.currentThread();
        Runnable watchdogRunnable = () -> {
            while (upgradeTaskThread.isAlive() && !Thread.currentThread().isInterrupted()) {
                try {
                    upgradeTaskThread.join(interval.toMillis());
                }
                catch (InterruptedException e) {
                    break;
                }
                log.info(message);
            }
            log.info("Stopping monitoring of upgrade task by {}", (Object)watchdogThreadName);
        };
        Thread watchdogThread = new Thread(watchdogRunnable, watchdogThreadName);
        watchdogThread.setDaemon(true);
        watchdogThread.start();
        return watchdogThread;
    }
}

