/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user;

import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.user.UserFilter;
import com.atlassian.jira.user.UserFilterManager;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.collections.CollectionUtils;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.EntityExpr;
import org.ofbiz.core.entity.EntityOperator;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultUserFilterManager
implements UserFilterManager {
    private static final Logger log = LoggerFactory.getLogger(DefaultUserFilterManager.class);
    static final String TABLE_USERPICKER_FILTER = "UserPickerFilter";
    static final String TABLE_USERPICKER_FILTER_GROUP = "UserPickerFilterGroup";
    static final String TABLE_USERPICKER_FILTER_ROLE = "UserPickerFilterRole";
    private final OfBizDelegator delegator;

    public DefaultUserFilterManager(OfBizDelegator delegator) {
        this.delegator = delegator;
    }

    public UserFilter getFilter(FieldConfig fieldConfig) {
        if (fieldConfig == null) {
            return null;
        }
        GenericValue gv = this.getFilterGV(fieldConfig.getId());
        if (gv == null) {
            return UserFilter.DISABLED;
        }
        return this.convertGVToFilter(gv);
    }

    private GenericValue getFilterGV(Long fieldConfigId) {
        List genericValues = this.delegator.findByField(TABLE_USERPICKER_FILTER, "customfieldconfig", (Object)fieldConfigId);
        if (CollectionUtils.isEmpty((Collection)genericValues)) {
            return null;
        }
        if (genericValues.size() > 1) {
            log.warn("Incorrect data in user picker filter: more than one filter exist for the same fieldconfig id " + fieldConfigId + ". Returning the first one.");
        }
        return (GenericValue)genericValues.get(0);
    }

    private UserFilter convertGVToFilter(GenericValue gv) {
        if (!this.isEnabled(gv)) {
            return UserFilter.DISABLED;
        }
        return this.getFilterWithGroupsAndRoles(this.getFilterId(gv));
    }

    private boolean isEnabled(GenericValue gv) {
        return Boolean.TRUE.equals(gv.getBoolean("enabled"));
    }

    private UserFilter getFilterWithGroupsAndRoles(Long filterId) {
        List groupFilterGVs = this.delegator.findByField(TABLE_USERPICKER_FILTER_GROUP, "userpickerfilter", (Object)filterId);
        List roleFilterGVs = this.delegator.findByField(TABLE_USERPICKER_FILTER_ROLE, "userpickerfilter", (Object)filterId);
        return new UserFilter(true, this.convertGVsToGroupRoleIds(roleFilterGVs), this.convertGVsToGroupNames(groupFilterGVs));
    }

    private List<Long> convertGVsToGroupRoleIds(List<GenericValue> roleFilterGVs) {
        return ImmutableList.copyOf((Iterable)Iterables.transform(roleFilterGVs, (Function)new Function<GenericValue, Long>(){

            public Long apply(GenericValue gv) {
                return gv.getLong("projectroleid");
            }
        }));
    }

    private List<String> convertGVsToGroupNames(List<GenericValue> groupFilterGVs) {
        return ImmutableList.copyOf((Iterable)Iterables.transform(groupFilterGVs, (Function)new Function<GenericValue, String>(){

            public String apply(GenericValue gv) {
                return gv.getString("group");
            }
        }));
    }

    public void updateFilter(FieldConfig fieldConfig, UserFilter filter) {
        GenericValue gv = this.getFilterGV(fieldConfig.getId());
        if (gv == null) {
            if (filter.isEnabled()) {
                GenericValue newGV = this.delegator.createValue(TABLE_USERPICKER_FILTER, (Map)ImmutableMap.of((Object)"customfieldconfig", (Object)fieldConfig.getId(), (Object)"customfield", (Object)fieldConfig.getCustomField().getIdAsLong(), (Object)"enabled", (Object)Boolean.TRUE));
                this.createGroupsAndRoles(this.getFilterId(newGV), filter.getGroups(), filter.getRoleIds());
            }
        } else {
            boolean oldIsEnabled = this.isEnabled(gv);
            if (filter.isEnabled() != oldIsEnabled) {
                gv.set("enabled", (Object)filter.isEnabled());
                try {
                    gv.store();
                }
                catch (GenericEntityException e) {
                    throw new DataAccessException(e.getMessage(), (Throwable)e);
                }
            }
            Long filterId = this.getFilterId(gv);
            if (oldIsEnabled) {
                this.removeGroupsAndRoles(filterId);
            }
            if (filter.isEnabled()) {
                this.createGroupsAndRoles(filterId, filter.getGroups(), filter.getRoleIds());
            }
        }
    }

    public void removeFilter(Long customFieldId) {
        if (customFieldId == null) {
            ImmutableSet.of();
        } else {
            List genericValues = this.delegator.findByField(TABLE_USERPICKER_FILTER, "customfield", (Object)customFieldId);
            ImmutableList filterIds = ImmutableList.copyOf((Iterable)Iterables.filter((Iterable)Iterables.transform((Iterable)genericValues, (Function)new Function<GenericValue, Long>(){

                public Long apply(@Nullable GenericValue input) {
                    return input != null ? input.getLong("id") : null;
                }
            }), (Predicate)Predicates.notNull()));
            if (!filterIds.isEmpty()) {
                this.delegator.removeByCondition(TABLE_USERPICKER_FILTER_GROUP, (EntityCondition)new EntityExpr("userpickerfilter", EntityOperator.IN, (Object)filterIds));
                this.delegator.removeByCondition(TABLE_USERPICKER_FILTER_ROLE, (EntityCondition)new EntityExpr("userpickerfilter", EntityOperator.IN, (Object)filterIds));
                this.delegator.removeAll(genericValues);
            }
        }
    }

    private Long getFilterId(GenericValue gv) {
        return gv.getLong("id");
    }

    private void removeGroupsAndRoles(Long filterId) {
        this.delegator.removeByAnd(TABLE_USERPICKER_FILTER_GROUP, (Map)ImmutableMap.of((Object)"userpickerfilter", (Object)filterId));
        this.delegator.removeByAnd(TABLE_USERPICKER_FILTER_ROLE, (Map)ImmutableMap.of((Object)"userpickerfilter", (Object)filterId));
    }

    private void createGroupsAndRoles(Long filterId, Set<String> groups, Set<Long> roleIds) {
        if (groups != null) {
            for (String group : groups) {
                this.delegator.createValue(TABLE_USERPICKER_FILTER_GROUP, (Map)ImmutableMap.of((Object)"userpickerfilter", (Object)filterId, (Object)"group", (Object)group));
            }
        }
        if (roleIds != null) {
            for (Long roleId : roleIds) {
                this.delegator.createValue(TABLE_USERPICKER_FILTER_ROLE, (Map)ImmutableMap.of((Object)"userpickerfilter", (Object)filterId, (Object)"projectroleid", (Object)roleId));
            }
        }
    }

    static final class Entity {
        static final String ID = "id";
        static final String CONFIG_ID = "customfieldconfig";
        static final String CUSTOMFIELD_ID = "customfield";
        static final String ENABLED = "enabled";

        Entity() {
        }
    }

    static final class GroupEntity {
        static final String FILTER_ID = "userpickerfilter";
        static final String GROUP_NAME = "group";

        GroupEntity() {
        }
    }

    static final class RoleEntity {
        static final String FILTER_ID = "userpickerfilter";
        static final String ROLE_ID = "projectroleid";

        RoleEntity() {
        }
    }
}

