/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user.a11y;

import com.atlassian.jira.user.a11y.A11yPersonalSettingImageBean;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
@ParametersAreNonnullByDefault
public class A11yPersonalSettingBean {
    @XmlElement
    @Schema(example="a11y-setting-underlined-links")
    private final String key;
    @XmlElement
    @Schema(example="Underlined links")
    private final String label;
    @XmlElement
    @Schema(example="Underline links across Jira to make them more visible.")
    private final String description;
    @XmlElement
    private final A11yPersonalSettingImageBean image;
    @XmlElement
    private final boolean enabled;

    public A11yPersonalSettingBean(String key, String label, String description, @Nullable A11yPersonalSettingImageBean image, boolean enabled) {
        this.key = Objects.requireNonNull(key);
        this.label = Objects.requireNonNull(label);
        this.description = Objects.requireNonNull(description);
        this.image = image;
        this.enabled = enabled;
    }

    public String getKey() {
        return this.key;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        A11yPersonalSettingBean that = (A11yPersonalSettingBean)o;
        return this.enabled == that.enabled && Objects.equals(this.key, that.key) && Objects.equals(this.label, that.label) && Objects.equals(this.description, that.description) && Objects.equals(this.image, that.image);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.label, this.description, this.image, this.enabled);
    }

    public String toString() {
        return "A11yPersonalSettingBean{key='" + this.key + "', label='" + this.label + "', description='" + this.description + "', image='" + this.image + "', enabled=" + this.enabled + "}";
    }
}

