/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user.anonymize;

import com.atlassian.jira.plugin.AbstractJiraModuleDescriptor;
import com.atlassian.jira.plugin.OrderableModuleDescriptor;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.anonymize.AnonymizationHandler;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.module.Element;
import com.atlassian.plugin.module.ModuleFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AnonymizationHandlerModuleDescriptor<T extends AnonymizationHandler<P>, P>
extends AbstractJiraModuleDescriptor<T>
implements OrderableModuleDescriptor {
    private static final Logger log = LoggerFactory.getLogger(AnonymizationHandlerModuleDescriptor.class);
    private static final int DEFAULT_ORDER = 1000;
    private int order = 1000;

    protected AnonymizationHandlerModuleDescriptor(JiraAuthenticationContext authenticationContext, ModuleFactory moduleFactory) {
        super(authenticationContext, moduleFactory);
    }

    @Override
    public void init(Plugin plugin, Element element) throws PluginParseException {
        super.init(plugin, element);
        Element orderElement = element.element("order");
        if (orderElement != null) {
            try {
                this.order = Integer.parseInt(orderElement.getTextTrim());
            }
            catch (NumberFormatException e) {
                log.warn("Invalid order: " + orderElement.getTextTrim() + " for handler: " + this.getI18nNameKey() + ". Should be an integer.", (Throwable)e);
            }
        }
    }

    public int getOrder() {
        return this.order;
    }

    public String toString() {
        return this.getCompleteKey();
    }
}

