/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user.anonymize;

import com.atlassian.jira.bc.ServiceResultImpl;
import com.atlassian.jira.event.user.anonymize.UserAnonymizationFinishedEvent;
import com.atlassian.jira.event.user.anonymize.UserAnonymizationStartedEvent;
import com.atlassian.jira.task.context.Context;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.anonymize.AffectedEntity;
import com.atlassian.jira.user.anonymize.AffectedEntityType;
import com.atlassian.jira.user.anonymize.AnonymizationParameters;
import com.atlassian.jira.user.anonymize.BusinessLogicValidationResult;
import com.atlassian.jira.user.anonymize.ServiceOutcomeWithWarnings;
import com.atlassian.jira.user.anonymize.UserState;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.util.WarningCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public interface AnonymizeUserService {
    @Nonnull
    public AnonymizeValidationResult preValidateAnonymize(@Nonnull AnonymizationParameters var1);

    @Nonnull
    public AnonymizeValidationResult validateAnonymize(@Nonnull AnonymizationParameters var1);

    @Nonnull
    public AnonymizePerformResult perform(@Nonnull AnonymizeValidationResult var1, @Nonnull Context var2);

    public int getStepCount(@Nonnull AnonymizeValidationResult var1);

    public static class AnonymizeValidationResult
    extends ServiceResultImpl {
        private final AnonymizationParameters request;
        private final AnonymizeProcessData processData;
        private final OperationsReport<Collection<AffectedEntity>> affectedEntitiesReport;
        private final OperationsReport<Void> operationValidation;
        private final ErrorCollection warnings;
        private final BusinessLogicValidationResult businessLogicValidationResult;

        public AnonymizeValidationResult(@Nonnull ErrorCollection errors, @Nonnull AnonymizationParameters request, @Nullable AnonymizeProcessData processData, @Nonnull OperationsReport<Collection<AffectedEntity>> affectedEntitiesReport, @Nonnull OperationsReport<Void> operationValidation) {
            this(errors, (ErrorCollection)new SimpleErrorCollection(), request, processData, affectedEntitiesReport, operationValidation);
        }

        public AnonymizeValidationResult(@Nonnull ErrorCollection errors, @Nonnull ErrorCollection warnings, @Nonnull AnonymizationParameters request, @Nullable AnonymizeProcessData processData, @Nonnull OperationsReport<Collection<AffectedEntity>> affectedEntitiesReport, @Nonnull OperationsReport<Void> operationValidation) {
            this(errors, warnings, request, processData, affectedEntitiesReport, operationValidation, BusinessLogicValidationResult.empty());
        }

        private AnonymizeValidationResult(@Nonnull ErrorCollection errors, @Nonnull ErrorCollection warnings, @Nonnull AnonymizationParameters request, @Nullable AnonymizeProcessData processData, @Nonnull OperationsReport<Collection<AffectedEntity>> affectedEntitiesReport, @Nonnull OperationsReport<Void> operationValidation, @Nonnull BusinessLogicValidationResult businessLogicValidationResult) {
            super(errors);
            this.warnings = Objects.requireNonNull(warnings);
            this.request = Objects.requireNonNull(request);
            this.processData = processData;
            this.affectedEntitiesReport = affectedEntitiesReport;
            this.operationValidation = Objects.requireNonNull(operationValidation);
            this.businessLogicValidationResult = Objects.requireNonNull(businessLogicValidationResult);
        }

        public static AnonymizeValidationResult fromFailedBusinessLogicValidation(@Nonnull AnonymizationParameters anonymizationParameters, @Nonnull BusinessLogicValidationResult businessLogicValidationResult) {
            return new AnonymizeValidationResult((ErrorCollection)new SimpleErrorCollection(), (ErrorCollection)new SimpleErrorCollection(), anonymizationParameters, null, new OperationsReport<Collection<AffectedEntity>>(), new OperationsReport<Void>(), businessLogicValidationResult);
        }

        @Nonnull
        public AnonymizationParameters getRequest() {
            return this.request;
        }

        @Nullable
        public AnonymizeProcessData getProcessData() {
            return this.processData;
        }

        @Nonnull
        public OperationsReport<Void> getOperationValidation() {
            return this.operationValidation;
        }

        @Nonnull
        public OperationsReport<Collection<AffectedEntity>> getAffectedEntitiesReport() {
            return this.affectedEntitiesReport;
        }

        public boolean isValid() {
            return super.isValid() && this.affectedEntitiesReport.isValid() && this.operationValidation.isValid() && this.businessLogicValidationResultValid();
        }

        private boolean businessLogicValidationResultValid() {
            return this.businessLogicValidationResult == null || this.businessLogicValidationResult.isValid();
        }

        @Nonnull
        public ErrorCollection getWarnings() {
            return this.warnings;
        }

        public WarningCollection getWarningCollection() {
            throw new UnsupportedOperationException("Please use getWarnings() method");
        }

        public boolean hasWarnings() {
            return this.getWarnings().hasAnyErrors();
        }

        @Nonnull
        public BusinessLogicValidationResult getBusinessLogicValidationResult() {
            return this.businessLogicValidationResult;
        }
    }

    public static class AnonymizePerformResult
    implements Serializable {
        private static final long serialVersionUID = -3559613157295216680L;
        private final AnonymizationParameters request;
        private final transient AnonymizeProcessData processData;
        private final OperationsReport<Void> report;

        public AnonymizePerformResult(AnonymizationParameters request, AnonymizeProcessData processData, OperationsReport<Void> report) {
            this.request = request;
            this.processData = processData;
            this.report = report;
        }

        public AnonymizationParameters getRequest() {
            return this.request;
        }

        public AnonymizeProcessData getProcessData() {
            return this.processData;
        }

        public OperationsReport<Void> getReport() {
            return this.report;
        }
    }

    public static class OperationsReport<T>
    implements Serializable {
        private static final long serialVersionUID = -971452978077171336L;
        private Map<AnonymizeOperation, SingleOperationReport<T>> reportMap = new EnumMap<AnonymizeOperation, SingleOperationReport<T>>(AnonymizeOperation.class);

        @Nonnull
        public Optional<SingleOperationReport<T>> getReport(@Nonnull AnonymizeOperation operation) {
            return Optional.ofNullable(this.reportMap.get((Object)operation));
        }

        public void putReport(@Nonnull SingleOperationReport<T> report) {
            this.reportMap.put(report.getOperation(), report);
        }

        public boolean isValid() {
            return this.reportMap.values().stream().allMatch(SingleOperationReport::isValid);
        }

        public boolean isEmpty() {
            return this.reportMap.isEmpty();
        }

        public Collection<SingleOperationReport<T>> getReports() {
            return ImmutableList.copyOf(this.reportMap.values());
        }

        public Collection<AnonymizeOperation> getOperations() {
            return ImmutableList.copyOf(this.reportMap.keySet());
        }

        public String toString() {
            return "OperationsReport{reportMap=" + this.reportMap + "}";
        }
    }

    public static class SingleOperationReport<T>
    implements Serializable {
        private final AnonymizeOperation operation;
        private final ServiceOutcomeWithWarnings<T> result;

        public SingleOperationReport(@Nonnull AnonymizeOperation operation, @Nonnull ServiceOutcomeWithWarnings<T> result) {
            this.operation = Objects.requireNonNull(operation);
            this.result = Objects.requireNonNull(result);
        }

        @Nonnull
        public AnonymizeOperation getOperation() {
            return this.operation;
        }

        @Nonnull
        public ServiceOutcomeWithWarnings<T> getResult() {
            return this.result;
        }

        public boolean isValid() {
            return this.result.isValid();
        }

        public String toString() {
            return "SingleOperationReport{operation=" + this.operation + ", result=" + this.result + "}";
        }
    }

    public static enum AnonymizeOperation {
        USER_TRANSFER_OWNERSHIP_PLUGIN_POINTS,
        USER_DISABLE,
        USER_KEY_CHANGE_PLUGIN_POINTS,
        USER_KEY_CHANGE,
        USER_NAME_CHANGE_PLUGIN_POINTS,
        USER_NAME_CHANGE,
        USER_EXTERNAL_ID_CHANGE,
        USER_ANONYMIZE_PLUGIN_POINTS;

    }

    public static class AnonymizeProcessData {
        private final AnonymizationParameters anonymizationParameters;
        private final ApplicationUser user;
        private final boolean userDeletedExternally;
        private final boolean userDeleted;
        private final boolean userNameAlreadyAnonymized;
        private final boolean userKeyAlreadyAnonymized;
        private final String newUserName;
        private final String newUserKey;
        private final Collection<AffectedEntity> affectedEntities;
        private final boolean affectedEntitiesWithHandlerError;

        public AnonymizeProcessData(@Nonnull AnonymizationParameters anonymizationParameters, @Nullable ApplicationUser user, boolean userDeletedExternally, boolean userDeleted, boolean userNameAlreadyAnonymized, boolean userKeyAlreadyAnonymized, @Nullable String newUserName, @Nullable String newUserKey, @Nonnull Collection<AffectedEntity> affectedEntities, boolean affectedEntitiesWithHandlerError) {
            this.anonymizationParameters = Objects.requireNonNull(anonymizationParameters);
            this.user = user;
            this.userDeletedExternally = userDeletedExternally;
            this.userDeleted = userDeleted;
            this.userNameAlreadyAnonymized = userNameAlreadyAnonymized;
            this.userKeyAlreadyAnonymized = userKeyAlreadyAnonymized;
            this.newUserName = newUserName;
            this.newUserKey = newUserKey;
            this.affectedEntities = Objects.requireNonNull(affectedEntities);
            this.affectedEntitiesWithHandlerError = affectedEntitiesWithHandlerError;
        }

        private AnonymizeProcessData(Builder builder) {
            this.anonymizationParameters = builder.anonymizationParameters;
            this.user = builder.user;
            this.userDeletedExternally = builder.userDeletedExternally;
            this.userDeleted = builder.userDeleted;
            this.userNameAlreadyAnonymized = builder.userNameAlreadyAnonymized;
            this.userKeyAlreadyAnonymized = builder.userKeyAlreadyAnonymized;
            this.newUserName = builder.newUserName;
            this.newUserKey = builder.newUserKey;
            this.affectedEntities = builder.affectedEntities;
            this.affectedEntitiesWithHandlerError = builder.affectedEntitiesWithHandlerError;
        }

        public static Builder newBuilder(@Nonnull AnonymizationParameters anonymizationParameters) {
            return new Builder(anonymizationParameters);
        }

        public AnonymizationParameters getAnonymizationParameters() {
            return this.anonymizationParameters;
        }

        public boolean handleOperation(AnonymizeOperation anonymizeOperation) {
            if (this.user == null) {
                return false;
            }
            return this.getOperationsWeWouldLikeToPerform(false).contains((Object)anonymizeOperation);
        }

        public Collection<AnonymizeOperation> getOperationsWeWouldLikeToPerform(boolean preValidate) {
            ImmutableSet.Builder operations = ImmutableSet.builder();
            if (this.user == null) {
                return operations.build();
            }
            if (preValidate) {
                if (this.isRequiresTransferOwnerDuringPreValidate()) {
                    operations.add((Object)AnonymizeOperation.USER_TRANSFER_OWNERSHIP_PLUGIN_POINTS);
                }
            } else if (this.isRequiresTransferOwner()) {
                operations.add((Object)AnonymizeOperation.USER_TRANSFER_OWNERSHIP_PLUGIN_POINTS);
            }
            if (this.isUserActive()) {
                operations.add((Object)AnonymizeOperation.USER_DISABLE);
            }
            if (this.getUserState() == UserState.PRESENT) {
                operations.add((Object)AnonymizeOperation.USER_EXTERNAL_ID_CHANGE);
            }
            operations.add((Object)AnonymizeOperation.USER_ANONYMIZE_PLUGIN_POINTS);
            if (!this.userKeyAlreadyAnonymized) {
                operations.add((Object)AnonymizeOperation.USER_KEY_CHANGE);
            }
            if (!this.userKeyAlreadyAnonymized || this.userKeyAnonymizedButRerunPluginPointsRequested()) {
                operations.add((Object)AnonymizeOperation.USER_KEY_CHANGE_PLUGIN_POINTS);
            }
            if (!this.userNameAlreadyAnonymized) {
                operations.add((Object)AnonymizeOperation.USER_NAME_CHANGE);
            }
            if (!this.userNameAlreadyAnonymized || this.userNameAnonymizedButRerunPluginPointsRequested()) {
                operations.add((Object)AnonymizeOperation.USER_NAME_CHANGE_PLUGIN_POINTS);
            }
            return operations.build();
        }

        private boolean userNameAnonymizedButRerunPluginPointsRequested() {
            return this.userNameAlreadyAnonymized && this.anonymizationParameters.isRerunPluginPoints() && (StringUtils.isBlank((CharSequence)this.anonymizationParameters.getOldUserName()) || !this.anonymizationParameters.getOldUserName().equals(this.user.getName()));
        }

        private boolean userKeyAnonymizedButRerunPluginPointsRequested() {
            return this.userKeyAlreadyAnonymized && this.anonymizationParameters.isRerunPluginPoints() && (StringUtils.isBlank((CharSequence)this.anonymizationParameters.getOldUserKey()) || !this.anonymizationParameters.getOldUserKey().equals(this.user.getKey()));
        }

        public boolean isRequiresTransferOwner() {
            return !this.getAnonymizationParameters().isGetAffectedEntities() || this.affectedEntitiesWithHandlerError || this.affectedEntities.stream().anyMatch(affectedEntity -> affectedEntity.getType() == AffectedEntityType.TRANSFER_OWNERSHIP);
        }

        private boolean isRequiresTransferOwnerDuringPreValidate() {
            return true;
        }

        @Nullable
        public ApplicationUser getUser() {
            return this.user;
        }

        public UserState getUserState() {
            return UserState.getUserState(this.user);
        }

        public boolean isUserDeletedExternally() {
            return this.userDeletedExternally;
        }

        public boolean isUserDeleted() {
            return this.userDeleted;
        }

        public boolean isUserNameAlreadyAnonymized() {
            return this.userNameAlreadyAnonymized;
        }

        public boolean isUserKeyAlreadyAnonymized() {
            return this.userKeyAlreadyAnonymized;
        }

        @Nullable
        public String getNewUserName() {
            return this.newUserName;
        }

        @Nullable
        public String getNewUserKey() {
            return this.newUserKey;
        }

        @Nullable
        public String getOldUserName() {
            return this.anonymizationParameters.getOldUserName();
        }

        @Nullable
        public String getOldUserKey() {
            return this.anonymizationParameters.getOldUserKey();
        }

        public String getTransferOwnerKey() {
            return this.anonymizationParameters.getNewOwnerKey();
        }

        @Nonnull
        public Collection<AffectedEntity> getAffectedEntities() {
            return this.affectedEntities;
        }

        public boolean isAffectedEntitiesWithHandlerError() {
            return this.affectedEntitiesWithHandlerError;
        }

        private boolean isUserActive() {
            return Optional.ofNullable(this.user).map(ApplicationUser::isActive).orElse(false);
        }

        @Nonnull
        public UserAnonymizationStartedEvent getUserAnonymizationStartedEvent() {
            if (this.user == null) {
                throw new IllegalStateException();
            }
            return new UserAnonymizationStartedEvent(this.user.getKey(), this.user.getUsername());
        }

        @Nonnull
        public UserAnonymizationFinishedEvent getUserAnonymizationFinishedEvent() {
            if (this.user == null) {
                throw new IllegalStateException();
            }
            String userKey = this.user.getKey();
            String userName = this.user.getUsername();
            String oldUserKey = this.user.getKey();
            String oldUserName = this.user.getUsername();
            String reRunUserKey = null;
            String reRunUserName = null;
            if (this.getAnonymizationParameters().isRerunPluginPoints()) {
                reRunUserKey = this.getAnonymizationParameters().getOldUserKey();
                reRunUserName = this.getAnonymizationParameters().getOldUserName();
            }
            if (this.getOperationsWeWouldLikeToPerform(false).contains((Object)AnonymizeOperation.USER_KEY_CHANGE)) {
                userKey = this.newUserKey;
                if (this.getAnonymizationParameters().isRerunPluginPoints()) {
                    oldUserKey = this.getAnonymizationParameters().getOldUserKey();
                }
            }
            if (this.getOperationsWeWouldLikeToPerform(false).contains((Object)AnonymizeOperation.USER_NAME_CHANGE)) {
                userName = this.newUserName;
                if (this.getAnonymizationParameters().isRerunPluginPoints()) {
                    oldUserName = this.getAnonymizationParameters().getOldUserName();
                }
            }
            return new UserAnonymizationFinishedEvent(userKey, userName, oldUserKey, oldUserName, this.getAnonymizationParameters().isRerunPluginPoints(), reRunUserKey, reRunUserName);
        }

        public static final class Builder {
            private AnonymizationParameters anonymizationParameters;
            private ApplicationUser user;
            private boolean userDeletedExternally;
            private boolean userDeleted;
            private boolean userNameAlreadyAnonymized;
            private boolean userKeyAlreadyAnonymized;
            private String newUserName;
            private String newUserKey;
            private Collection<AffectedEntity> affectedEntities = Collections.emptyList();
            private boolean affectedEntitiesWithHandlerError;

            private Builder(@Nonnull AnonymizationParameters anonymizationParameters) {
                this.anonymizationParameters = Objects.requireNonNull(anonymizationParameters);
            }

            public Builder user(@Nullable ApplicationUser user) {
                this.user = user;
                return this;
            }

            public Builder userDeletedExternally(boolean userDeletedExternally) {
                this.userDeletedExternally = userDeletedExternally;
                return this;
            }

            public Builder userDeleted(boolean userDeleted) {
                this.userDeleted = userDeleted;
                return this;
            }

            public Builder userNameAlreadyAnonymized(boolean userNameAlreadyAnonymized) {
                this.userNameAlreadyAnonymized = userNameAlreadyAnonymized;
                return this;
            }

            public Builder userKeyAlreadyAnonymized(boolean userKeyAlreadyAnonymized) {
                this.userKeyAlreadyAnonymized = userKeyAlreadyAnonymized;
                return this;
            }

            public Builder newUserName(String newUserName) {
                this.newUserName = newUserName;
                return this;
            }

            public Builder newUserKey(String newUserKey) {
                this.newUserKey = newUserKey;
                return this;
            }

            public Builder affectedEntities(@Nonnull Collection<AffectedEntity> affectedEntities) {
                this.affectedEntities = Objects.requireNonNull(affectedEntities);
                return this;
            }

            public Builder affectedEntitiesWithHandlerError(boolean affectedEntitiesWithHandlerError) {
                this.affectedEntitiesWithHandlerError = affectedEntitiesWithHandlerError;
                return this;
            }

            public AnonymizeProcessData build() {
                return new AnonymizeProcessData(this);
            }
        }
    }
}

