/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user.anonymize;

import com.atlassian.jira.task.TaskContext;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AnonymizeUserTaskContext
implements TaskContext {
    private static final long serialVersionUID = 2695677117346592812L;
    public static final AnonymizeUserTaskContext EMPTY = new AnonymizeUserTaskContext("", false);
    private final String userKey;
    private final String userName;
    private final String fullName;
    private final boolean rerun;

    public AnonymizeUserTaskContext(@Nonnull String userKey, boolean rerun) {
        this(userKey, null, null, rerun);
    }

    public AnonymizeUserTaskContext(@Nonnull String userKey, String userName, boolean rerun) {
        this(userKey, userName, null, rerun);
    }

    public AnonymizeUserTaskContext(@Nonnull String userKey, @Nullable String userName, @Nullable String fullName, boolean rerun) {
        this.userKey = Objects.requireNonNull(userKey);
        this.userName = userName;
        this.fullName = fullName;
        this.rerun = rerun;
    }

    @Nonnull
    public String getUserKey() {
        return this.userKey;
    }

    @Nullable
    public String getUserName() {
        return this.userName;
    }

    @Nullable
    public String getFullName() {
        return this.fullName;
    }

    public boolean isRerun() {
        return this.rerun;
    }

    @Override
    public String buildProgressURL(Long taskId) {
        return "/rest/api/2/user/anonymization/progress?taskId=" + taskId;
    }

    public int hashCode() {
        return AnonymizeUserTaskContext.class.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof AnonymizeUserTaskContext;
    }

    public String toString() {
        return "AnonymizeUserTaskContext{userKey='" + this.userKey + "', userName='" + this.userName + "', fullName='" + this.fullName + "', isRerun=" + this.rerun + "}";
    }
}

