/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user.anonymize;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.user.anonymize.AnonymizationHandler;
import com.atlassian.jira.user.anonymize.AnonymizationHandlerModuleDescriptor;
import com.atlassian.jira.user.anonymize.AnonymizationParameters;
import com.atlassian.jira.user.anonymize.BusinessLogicValidationResult;
import com.atlassian.jira.user.anonymize.TaskContextAware;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableMap;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public class BusinessLogicValidator {
    private static final Logger log = LoggerFactory.getLogger(BusinessLogicValidator.class);
    private final EventPublisher eventPublisher;
    private final I18nHelper i18nHelper;
    private static final Duration VALIDATION_DURATION_ANALYTICS_THRESHOLD = Duration.ofSeconds(2L);

    public BusinessLogicValidator(EventPublisher eventPublisher, I18nHelper i18nHelper) {
        this.eventPublisher = eventPublisher;
        this.i18nHelper = i18nHelper;
    }

    @Nonnull
    public <P extends TaskContextAware, T extends AnonymizationHandler<P>> BusinessLogicValidationResult validate(List<? extends AnonymizationHandlerModuleDescriptor<T, P>> moduleDescriptors, AnonymizationParameters anonymizationParameters) {
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        for (AnonymizationHandlerModuleDescriptor<T, P> moduleDescriptor : moduleDescriptors) {
            ErrorCollection validationErrors = new MeasuringValidator<T, P>(anonymizationParameters, moduleDescriptor).validate();
            if (validationErrors == null) continue;
            mapBuilder.put((Object)moduleDescriptor.getCompleteKey(), (Object)validationErrors);
        }
        return new BusinessLogicValidationResult((Map<String, ? extends ErrorCollection>)mapBuilder.build());
    }

    @VisibleForTesting
    Stopwatch getStopwatch() {
        return Stopwatch.createUnstarted();
    }

    private class MeasuringValidator<T extends AnonymizationHandler<P>, P extends TaskContextAware> {
        private final AnonymizationParameters anonymizationParameters;
        private final AnonymizationHandlerModuleDescriptor<T, P> moduleDescriptor;
        private final T handler;

        public MeasuringValidator(AnonymizationParameters anonymizationParameters, AnonymizationHandlerModuleDescriptor<T, P> moduleDescriptor) {
            this.anonymizationParameters = anonymizationParameters;
            this.moduleDescriptor = moduleDescriptor;
            this.handler = (AnonymizationHandler)moduleDescriptor.getModule();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        private ErrorCollection validate() {
            ErrorCollection errorCollection;
            Stopwatch stopwatch = BusinessLogicValidator.this.getStopwatch();
            stopwatch.start();
            try {
                errorCollection = this.handler.validateBusinessLogic(this.anonymizationParameters);
            }
            catch (Exception ex) {
                SimpleErrorCollection simpleErrorCollection;
                try {
                    log.error("An error occured when validating business logic for handler " + this.moduleDescriptor.getCompleteKey(), (Throwable)ex);
                    simpleErrorCollection = new SimpleErrorCollection(BusinessLogicValidator.this.i18nHelper.getText("admin.user.anonymize.exception.during.business.logic.validation"));
                }
                catch (Throwable throwable) {
                    Duration elapsed = stopwatch.stop().elapsed();
                    this.emitAnalyticsIfNecessary(elapsed);
                    log.info(String.format("Business logic validation took %s for module with key %s.", elapsed, this.moduleDescriptor.getKey()));
                    throw throwable;
                }
                Duration elapsed = stopwatch.stop().elapsed();
                this.emitAnalyticsIfNecessary(elapsed);
                log.info(String.format("Business logic validation took %s for module with key %s.", elapsed, this.moduleDescriptor.getKey()));
                return simpleErrorCollection;
            }
            Duration elapsed = stopwatch.stop().elapsed();
            this.emitAnalyticsIfNecessary(elapsed);
            log.info(String.format("Business logic validation took %s for module with key %s.", elapsed, this.moduleDescriptor.getKey()));
            return errorCollection;
        }

        private void emitAnalyticsIfNecessary(Duration elapsed) {
            if (elapsed.compareTo(VALIDATION_DURATION_ANALYTICS_THRESHOLD) > 0) {
                BusinessLogicValidator.this.eventPublisher.publish((Object)new LongBusinessLogicValidationEvent(this.moduleDescriptor.getCompleteKey(), elapsed));
            }
        }
    }

    @EventName(value="jira.user.anonymization.long.business.logic.validation")
    public static class LongBusinessLogicValidationEvent {
        private final String moduleDescriptorCompleteKey;
        private final long secondsElapsed;

        public LongBusinessLogicValidationEvent(String completeKey, Duration elapsed) {
            this.moduleDescriptorCompleteKey = completeKey;
            this.secondsElapsed = elapsed.getSeconds();
        }

        public String getModuleDescriptorCompleteKey() {
            return this.moduleDescriptorCompleteKey;
        }

        public long getSecondsElapsed() {
            return this.secondsElapsed;
        }

        public String toString() {
            return "LongBusinessLogicValidationEvent{moduleDescriptorCompleteKey='" + this.moduleDescriptorCompleteKey + "', secondsElapsed=" + this.secondsElapsed + "}";
        }
    }
}

