/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user.anonymize;

import com.atlassian.jira.task.context.Context;
import com.atlassian.jira.user.anonymize.AdditionalAnonymizationData;
import com.atlassian.jira.user.anonymize.UserAnonymizationParameter;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class UserAnonymizationParameterWithAdditionalData
extends UserAnonymizationParameter
implements AdditionalAnonymizationData {
    private final String fullName;

    public UserAnonymizationParameterWithAdditionalData(@Nonnull String userKey) {
        super(userKey);
        this.fullName = null;
    }

    public UserAnonymizationParameterWithAdditionalData(@Nonnull String userKey, @Nullable String fullName) {
        super(userKey);
        this.fullName = fullName;
    }

    public UserAnonymizationParameterWithAdditionalData(@Nonnull String userKey, @Nullable String fullName, @Nonnull Context context) {
        super(userKey, context);
        this.fullName = fullName;
    }

    @Override
    public Optional<String> getFullName() {
        return Optional.ofNullable(this.fullName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        UserAnonymizationParameterWithAdditionalData that = (UserAnonymizationParameterWithAdditionalData)o;
        return Objects.equals(this.fullName, that.fullName);
    }

    public String toString() {
        return "UserAnonymizationParameterWithAdditionalData{userKey='" + this.getUserKey() + "'fullName='" + this.fullName + "'}";
    }
}

