/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user.anonymize.handlers.anonymize;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.annotations.nonnull.ReturnValuesAreNonnullByDefault;
import com.atlassian.jira.bc.ServiceResult;
import com.atlassian.jira.bc.ServiceResultImpl;
import com.atlassian.jira.database.DatabaseAccessor;
import com.atlassian.jira.database.QueryDslAccessor;
import com.atlassian.jira.user.anonymize.AffectedEntity;
import com.atlassian.jira.user.anonymize.AffectedEntityType;
import com.atlassian.jira.user.anonymize.ContextUtil;
import com.atlassian.jira.user.anonymize.UserAnonymizationHandler;
import com.atlassian.jira.user.anonymize.UserAnonymizationParameter;
import com.atlassian.jira.user.anonymize.handlers.anonymize.DisplayNameInMultiUserFieldHistory;
import com.atlassian.jira.user.anonymize.handlers.anonymize.DisplayNameInSingleUserFieldHistory;
import com.atlassian.jira.user.util.UserKeyStore;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.util.SimpleWarningCollection;
import com.atlassian.jira.util.WarningCollection;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
@ReturnValuesAreNonnullByDefault
public class DisplayNameInIssueHistoryHandler
implements UserAnonymizationHandler {
    private final List<UserAnonymizationHandler> delegates;

    public DisplayNameInIssueHistoryHandler(QueryDslAccessor queryDslAccessor, DatabaseAccessor databaseAccessor, UserManager userManager, UserKeyStore userKeyStore) {
        this.delegates = ImmutableList.of((Object)new DisplayNameInSingleUserFieldHistory(queryDslAccessor, databaseAccessor, userManager, userKeyStore), (Object)new DisplayNameInMultiUserFieldHistory(queryDslAccessor, databaseAccessor, userManager, userKeyStore));
    }

    @VisibleForTesting
    DisplayNameInIssueHistoryHandler(List<UserAnonymizationHandler> delegates) {
        this.delegates = ImmutableList.copyOf(delegates);
    }

    public Collection<AffectedEntity> getAffectedEntities(UserAnonymizationParameter parameter) {
        return ImmutableList.of((Object)AffectedEntity.newBuilder((AffectedEntityType)AffectedEntityType.ANONYMIZE).descriptionKey("user.anonymization.handler.display.name.issue.history").build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceResult update(UserAnonymizationParameter parameter) {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        SimpleWarningCollection warningCollection = new SimpleWarningCollection();
        int remainingProgress = this.getNumberOfTasks(parameter);
        int step = remainingProgress / this.delegates.size();
        try {
            for (UserAnonymizationHandler handler : this.delegates) {
                ServiceResultImpl result = new ServiceResultImpl();
                try {
                    result = DisplayNameInIssueHistoryHandler.doUpdate(handler, parameter);
                }
                finally {
                    remainingProgress -= step;
                    ContextUtil.updateProgress(parameter.getContext(), step);
                }
                errorCollection.addErrorCollection(result.getErrorCollection());
                warningCollection.addWarnings(result.getWarningCollection());
            }
        }
        finally {
            ContextUtil.updateProgress(parameter.getContext(), remainingProgress);
        }
        return new ServiceResultImpl((ErrorCollection)errorCollection, (WarningCollection)warningCollection);
    }

    private static ServiceResult doUpdate(UserAnonymizationHandler handler, UserAnonymizationParameter parameter) {
        ServiceResult result;
        try {
            result = handler.update((Object)parameter);
        }
        catch (Exception e) {
            result = new ServiceResultImpl((ErrorCollection)new SimpleErrorCollection(e.getMessage()));
        }
        return result;
    }

    public int getNumberOfTasks(UserAnonymizationParameter userPropertyChangeParameter) {
        return 5000;
    }
}

