/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user.anonymize.handlers.key;

import com.atlassian.jira.bc.ServiceOutcomeImpl;
import com.atlassian.jira.bc.ServiceResult;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.task.context.Context;
import com.atlassian.jira.user.anonymize.AffectedEntity;
import com.atlassian.jira.user.anonymize.AffectedEntityType;
import com.atlassian.jira.user.anonymize.ContextUtil;
import com.atlassian.jira.user.anonymize.UserKeyChangeHandler;
import com.atlassian.jira.user.anonymize.UserPropertyChangeParameter;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowException;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.jira.workflow.function.issue.UpdateIssueFieldFunction;
import com.google.common.collect.ImmutableList;
import com.opensymphony.workflow.loader.ActionDescriptor;
import com.opensymphony.workflow.loader.FunctionDescriptor;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractUserKeyInWorkflowChangeHandler
implements UserKeyChangeHandler {
    private static final Logger log = LoggerFactory.getLogger(AbstractUserKeyInWorkflowChangeHandler.class);
    private static final String FUNCTION_CLASS_NAME = "class.name";
    private static final String FUNCTION_DESCRIPTOR_TYPE_CLASS = "class";
    protected final WorkflowManager workflowManager;
    private final JiraAuthenticationContext jiraAuthenticationContext;

    public AbstractUserKeyInWorkflowChangeHandler(WorkflowManager workflowManager, JiraAuthenticationContext jiraAuthenticationContext) {
        this.workflowManager = workflowManager;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
    }

    @Nonnull
    public Collection<AffectedEntity> getAffectedEntities(@Nonnull UserPropertyChangeParameter userPropertyChangeParameter) {
        log.debug("Getting affected workflows for {}", (Object)userPropertyChangeParameter);
        List<JiraWorkflow> workflowsToUpdate = this.getWorkflowsUsingUserKey(userPropertyChangeParameter);
        log.debug("Got {} affected workflows for {}", (Object)workflowsToUpdate.size(), (Object)userPropertyChangeParameter);
        if (workflowsToUpdate.isEmpty()) {
            return Collections.emptyList();
        }
        return ImmutableList.of((Object)AffectedEntity.newBuilder((AffectedEntityType)AffectedEntityType.ANONYMIZE).descriptionKey(this.getDescriptionKey()).numberOfOccurrences(Long.valueOf(workflowsToUpdate.size())).build());
    }

    protected abstract String getDescriptionKey();

    protected abstract Collection<JiraWorkflow> getWorkflows();

    protected abstract String getTaskDescriptionKey();

    private List<JiraWorkflow> getWorkflowsUsingUserKey(@Nonnull UserPropertyChangeParameter userPropertyChangeParameter) {
        return this.getWorkflows().stream().filter(workflow -> this.containsUserKeyInMetadata((JiraWorkflow)workflow, userPropertyChangeParameter.getOriginal()) || this.containsUpdateIssueFieldFunctionWithUserKey((JiraWorkflow)workflow, userPropertyChangeParameter.getOriginal())).collect(Collectors.toList());
    }

    private boolean containsUpdateIssueFieldFunctionWithUserKey(JiraWorkflow workflow, String userKey) {
        Collection allActions = workflow.getAllActions();
        return allActions.stream().anyMatch(action -> this.hasUpdateIssueFieldFunctionWithUserKey((ActionDescriptor)action, userKey));
    }

    private boolean containsUserKeyInMetadata(JiraWorkflow workflow, String userKey) {
        return Optional.ofNullable(workflow.getDescriptor()).map(d -> d.getMetaAttributes()).map(attributes -> userKey.equals(attributes.get("jira.update.author.key"))).orElse(false);
    }

    private boolean hasUpdateIssueFieldFunctionWithUserKey(ActionDescriptor action, String userKey) {
        return this.getPostFunctions(action).stream().anyMatch(postFunction -> this.isUpdateFieldFunctionWithAssignee((FunctionDescriptor)postFunction, userKey));
    }

    private boolean isUpdateFieldFunctionWithAssignee(FunctionDescriptor functionDescriptor, String userKey) {
        Map args = functionDescriptor.getArgs();
        return FUNCTION_DESCRIPTOR_TYPE_CLASS.equals(functionDescriptor.getType()) && UpdateIssueFieldFunction.class.getName().equals(args.get(FUNCTION_CLASS_NAME)) && "assignee".equals(args.get("field.name")) && userKey.equals(args.get("field.value"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public ServiceResult update(@Nonnull UserPropertyChangeParameter userPropertyChangeParameter) {
        SimpleErrorCollection errors = new SimpleErrorCollection();
        Context context = userPropertyChangeParameter.getContext();
        int tasksNumber = this.getNumberOfTasks(userPropertyChangeParameter);
        context.setName(this.jiraAuthenticationContext.getI18nHelper().getText(this.getTaskDescriptionKey()));
        try {
            log.debug("Processing workflow user key change for {}", (Object)userPropertyChangeParameter);
            List<JiraWorkflow> workflowsToUpdate = this.getWorkflowsUsingUserKey(userPropertyChangeParameter);
            log.debug("Found {} workflows to update", (Object)workflowsToUpdate.size());
            for (JiraWorkflow workflow : workflowsToUpdate) {
                ServiceResult result = this.updateWorkflow(workflow, userPropertyChangeParameter);
                errors.addErrorCollection(result.getErrorCollection());
            }
            log.debug("End processing workflow user key change for {}", (Object)userPropertyChangeParameter);
        }
        catch (Exception e) {
            log.error("Exception during workflow handler processing", (Throwable)e);
            errors.addErrorMessage(this.jiraAuthenticationContext.getI18nHelper().getText("change.handler.processing.exception", e.getMessage()));
        }
        finally {
            ContextUtil.updateProgress(context, tasksNumber);
        }
        return ServiceOutcomeImpl.from((ErrorCollection)errors);
    }

    private ServiceResult updateWorkflow(@Nonnull JiraWorkflow workflow, @Nonnull UserPropertyChangeParameter userPropertyChangeParameter) {
        SimpleErrorCollection errors = new SimpleErrorCollection();
        try {
            log.debug("Updating workflow {} (draft: {}) update assignee field from {} to {}", new Object[]{workflow.getName(), workflow.isDraftWorkflow(), userPropertyChangeParameter.getOriginal(), userPropertyChangeParameter.getTarget()});
            if (this.containsUserKeyInMetadata(workflow, userPropertyChangeParameter.getOriginal())) {
                log.debug("Updating workflow metadata");
                workflow = Optional.ofNullable(this.workflowManager.getWorkflowClone(workflow.getName())).orElse(workflow);
                try {
                    workflow.getDescriptor().getMetaAttributes().put("jira.update.author.key", userPropertyChangeParameter.getTarget());
                }
                catch (Exception e) {
                    log.error("Exception during workflow metadata update for workflow: {}", (Object)workflow.getName(), (Object)e);
                    errors.addErrorMessage(this.jiraAuthenticationContext.getI18nHelper().getText("user.key.change.handler.workflow.metadata.error", workflow.getName(), "jira.update.author.key", e.getMessage()));
                }
            }
            JiraWorkflow workflowToUpdate = workflow;
            List<FunctionDescriptor> postFunctionsToUpdate = workflowToUpdate.getAllActions().stream().flatMap(actionDescriptor -> this.getPostFunctions((ActionDescriptor)actionDescriptor).stream()).filter(postFunction -> this.isUpdateFieldFunctionWithAssignee((FunctionDescriptor)postFunction, userPropertyChangeParameter.getOriginal())).collect(Collectors.toList());
            log.debug("Number for post functions to update: {}", (Object)postFunctionsToUpdate.size());
            postFunctionsToUpdate.forEach(postFunction -> {
                log.debug("Updating post function for workflow {}", (Object)workflowToUpdate.getName());
                postFunction.getArgs().put("field.value", userPropertyChangeParameter.getTarget());
            });
            log.debug("Saving workflow {}", (Object)workflowToUpdate.getName());
            this.workflowManager.saveWorkflowWithoutAudit(workflowToUpdate);
        }
        catch (WorkflowException e) {
            log.error("Exception during workflow anonymization processing", (Throwable)e);
            errors.addErrorMessage(this.jiraAuthenticationContext.getI18nHelper().getText("user.key.change.handler.workflow.processing.error", workflow.getName(), e.getMessage()));
        }
        return ServiceOutcomeImpl.from((ErrorCollection)errors);
    }

    private List<FunctionDescriptor> getPostFunctions(ActionDescriptor actionDescriptor) {
        return ImmutableList.builder().addAll((Iterable)actionDescriptor.getPostFunctions()).addAll((Iterable)actionDescriptor.getUnconditionalResult().getPostFunctions()).build();
    }
}

