/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user.anonymize.handlers.username.mention;

import com.atlassian.jira.user.anonymize.UserPropertyChangeParameter;
import com.atlassian.jira.user.anonymize.handlers.username.mention.MentionStringHelper;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.util.SimpleWarningCollection;
import com.atlassian.jira.util.WarningCollection;
import java.util.Objects;
import java.util.function.Function;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class MentionAnonymizationContext {
    private final UserPropertyChangeParameter changeParameter;
    private final Pattern mentionPattern;
    public final String mention;
    public final String mentionReplacement;
    public final ErrorCollection errors = new SimpleErrorCollection();
    public final WarningCollection warnings = new SimpleWarningCollection();

    public MentionAnonymizationContext(UserPropertyChangeParameter changeParameter) {
        this(changeParameter, Function.identity());
    }

    public MentionAnonymizationContext(UserPropertyChangeParameter changeParameter, Function<String, String> usernameMapper) {
        this.changeParameter = changeParameter;
        this.mention = MentionStringHelper.formatMention(usernameMapper.apply(changeParameter.getOriginal()));
        this.mentionReplacement = MentionStringHelper.formatMention(usernameMapper.apply(changeParameter.getTarget()));
        this.mentionPattern = MentionStringHelper.getMentionForUsernamePattern(usernameMapper.apply(changeParameter.getOriginal()));
    }

    @Nonnull
    public MentionAnonymizationContext withUsernameMapper(@Nonnull Function<String, String> usernameMapper) {
        return new MentionAnonymizationContext(this.changeParameter, Objects.requireNonNull(usernameMapper));
    }

    public String anonymizeMentions(@Nullable String str) {
        if (str == null) {
            return null;
        }
        return this.mentionPattern.matcher(str).replaceAll(this.mentionReplacement);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MentionAnonymizationContext that = (MentionAnonymizationContext)o;
        return Objects.equals(this.mention, that.mention) && Objects.equals(this.mentionReplacement, that.mentionReplacement) && Objects.equals(this.errors, that.errors) && Objects.equals(this.warnings, that.warnings);
    }

    public int hashCode() {
        return Objects.hash(this.mention, this.mentionReplacement, this.errors, this.warnings);
    }

    public String toString() {
        return "MentionAnonymizationContext{mention='" + this.mention + "', mentionReplacement='" + this.mentionReplacement + "', errors=" + this.errors + ", warnings=" + this.warnings + "}";
    }
}

