/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user.anonymize.handlers.utils;

import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class MultiValueChangeItemUtil {
    public static final String DELIMITER = ", ";
    public static final Pattern DELIMITER_PATTERN = Pattern.compile(", ");

    public static String replace(@Nullable String multiValue, @Nonnull String original, @Nonnull String target) {
        if (multiValue == null) {
            return null;
        }
        if (!multiValue.startsWith("[") || !multiValue.endsWith("]")) {
            return multiValue;
        }
        if (multiValue.startsWith("[")) {
            multiValue = multiValue.substring(1);
        }
        if (multiValue.endsWith("]")) {
            multiValue = multiValue.substring(0, multiValue.length() - 1);
        }
        return DELIMITER_PATTERN.splitAsStream(multiValue).filter(Objects::nonNull).map(key -> key.equals(original) ? target : key).collect(Collectors.joining(DELIMITER, "[", "]"));
    }
}

