/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user.anonymize.operations;

import com.atlassian.jira.user.anonymize.AnonymizeUserService;
import com.atlassian.jira.user.anonymize.operations.AnonymizeOperationStep;
import com.atlassian.jira.user.anonymize.operations.StepWithPluginPointInvocations;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AnonymizeOperationSteps {
    private final Map<AnonymizeUserService.AnonymizeOperation, AnonymizeOperationStep> operationToStep;
    private final AnonymizeUserService.AnonymizeOperation[] BLOCKING_OPERATIONS;
    private final AnonymizeUserService.AnonymizeOperation[] NON_BLOCKING_OPERATIONS;

    public AnonymizeOperationSteps(@Nonnull AnonymizeOperationStep[] steps) {
        Objects.requireNonNull(steps);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        Arrays.stream(steps).forEach(handler -> builder.put((Object)handler.getAnonymizeOperation(), handler));
        this.operationToStep = builder.build();
        this.BLOCKING_OPERATIONS = new AnonymizeUserService.AnonymizeOperation[]{AnonymizeUserService.AnonymizeOperation.USER_TRANSFER_OWNERSHIP_PLUGIN_POINTS, AnonymizeUserService.AnonymizeOperation.USER_DISABLE};
        this.NON_BLOCKING_OPERATIONS = new AnonymizeUserService.AnonymizeOperation[]{AnonymizeUserService.AnonymizeOperation.USER_ANONYMIZE_PLUGIN_POINTS, AnonymizeUserService.AnonymizeOperation.USER_EXTERNAL_ID_CHANGE, AnonymizeUserService.AnonymizeOperation.USER_KEY_CHANGE, AnonymizeUserService.AnonymizeOperation.USER_KEY_CHANGE_PLUGIN_POINTS, AnonymizeUserService.AnonymizeOperation.USER_NAME_CHANGE, AnonymizeUserService.AnonymizeOperation.USER_NAME_CHANGE_PLUGIN_POINTS};
    }

    public Collection<AnonymizeOperationStep> getStepsBlockingAnonymizationProcessOnFail() {
        return (Collection)this.getOperationSteps(this.BLOCKING_OPERATIONS).collect(ImmutableList.toImmutableList());
    }

    public Collection<AnonymizeOperationStep> getStepsNotBlockingAnonymizationProcessOnFail() {
        return (Collection)this.getOperationSteps(this.NON_BLOCKING_OPERATIONS).collect(ImmutableList.toImmutableList());
    }

    public Collection<StepWithPluginPointInvocations> getStepsForBusinessLogicValidation() {
        return (Collection)Stream.concat(this.getOperationSteps(this.BLOCKING_OPERATIONS), this.getOperationSteps(this.NON_BLOCKING_OPERATIONS)).filter(step -> step instanceof StepWithPluginPointInvocations).map(step -> (StepWithPluginPointInvocations)((Object)step)).collect(ImmutableList.toImmutableList());
    }

    private Stream<AnonymizeOperationStep> getOperationSteps(AnonymizeUserService.AnonymizeOperation[] operations) {
        return Arrays.stream(operations).map(this.operationToStep::get).filter(Objects::nonNull);
    }

    @Nullable
    public AnonymizeOperationStep getStep(@Nonnull AnonymizeUserService.AnonymizeOperation anonymizeOperation) {
        return this.operationToStep.get((Object)anonymizeOperation);
    }
}

