/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user.anonymize.operations;

import com.atlassian.jira.bc.ServiceResult;
import com.atlassian.jira.bc.ServiceResultImpl;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.task.context.Context;
import com.atlassian.jira.user.anonymize.AffectedEntity;
import com.atlassian.jira.user.anonymize.AnonymizationParameters;
import com.atlassian.jira.user.anonymize.AnonymizeUserService;
import com.atlassian.jira.user.anonymize.ServiceOutcomeWithWarnings;
import com.atlassian.jira.user.anonymize.externalid.UserExternalIdChangeService;
import com.atlassian.jira.user.anonymize.operations.AnonymizeOperationStep;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserExternalIdChangeOperationStep
implements AnonymizeOperationStep {
    private static final Logger log = LoggerFactory.getLogger(UserExternalIdChangeOperationStep.class);
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final UserExternalIdChangeService userExternalIdChangeService;

    public UserExternalIdChangeOperationStep(JiraAuthenticationContext jiraAuthenticationContext, UserExternalIdChangeService userExternalIdChangeService) {
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.userExternalIdChangeService = userExternalIdChangeService;
    }

    public Optional<AnonymizeUserService.SingleOperationReport<Void>> performOperation(@Nonnull AnonymizeUserService.OperationsReport anonymizeReport, @Nonnull AnonymizeUserService.AnonymizeValidationResult validationResult, @Nonnull Context asyncTaskContext) {
        Optional<AnonymizeUserService.SingleOperationReport<Void>> optional;
        block9: {
            AnonymizeUserService.AnonymizeProcessData processData = validationResult.getProcessData();
            if (!this.shouldPerformOperation(processData)) {
                log.info("Skipping changing external id");
                return Optional.empty();
            }
            String userKey = processData.getAnonymizationParameters().getUserKey();
            log.info("Changing user external id ({})", (Object)userKey);
            Context.Task task = asyncTaskContext.start(null);
            try {
                ServiceResult changeExternalIdResult = this.userExternalIdChangeService.changeExternalId(this.jiraAuthenticationContext.getLoggedInUser(), userKey);
                optional = Optional.of(new AnonymizeUserService.SingleOperationReport<Object>(AnonymizeUserService.AnonymizeOperation.USER_EXTERNAL_ID_CHANGE, new ServiceOutcomeWithWarnings<Object>(null, changeExternalIdResult.getErrorCollection(), new HashMap<String, ErrorCollection>())));
                if (task == null) break block9;
            }
            catch (Throwable changeExternalIdResult) {
                try {
                    if (task != null) {
                        try {
                            task.close();
                        }
                        catch (Throwable throwable) {
                            changeExternalIdResult.addSuppressed(throwable);
                        }
                    }
                    throw changeExternalIdResult;
                }
                catch (Exception e) {
                    SimpleErrorCollection errorCollection = new SimpleErrorCollection();
                    I18nHelper i18nBean = this.jiraAuthenticationContext.getI18nHelper();
                    String handlerDescription = i18nBean.getText("admin.user.externalId.change.handler.key.change");
                    log.error(String.format("Exception during AnonymizationHandler %s processing", handlerDescription), (Throwable)e);
                    errorCollection.addErrorMessage(i18nBean.getText("change.handler.processing.exception", e.getMessage()));
                    return Optional.of(new AnonymizeUserService.SingleOperationReport<Object>(AnonymizeUserService.AnonymizeOperation.USER_EXTERNAL_ID_CHANGE, new ServiceOutcomeWithWarnings<Object>(null, (ErrorCollection)errorCollection, new HashMap<String, ErrorCollection>())));
                }
            }
            task.close();
        }
        return optional;
    }

    @Override
    @Nonnull
    public ServiceResult validate(@Nonnull AnonymizeUserService.AnonymizeProcessData anonymizationProcessData, I18nHelper i18nHelper, boolean preValidate) {
        if (anonymizationProcessData.handleOperation(AnonymizeUserService.AnonymizeOperation.USER_EXTERNAL_ID_CHANGE)) {
            AnonymizationParameters request = anonymizationProcessData.getAnonymizationParameters();
            log.info("Validating changing user external id ({})", (Object)request.getUserKey());
            return this.userExternalIdChangeService.validate(this.jiraAuthenticationContext.getLoggedInUser(), request.getUserKey());
        }
        return new ServiceResultImpl();
    }

    @Override
    @Nonnull
    public ServiceOutcomeWithWarnings<Collection<AffectedEntity>> getAffectedEntities(AnonymizeUserService.AnonymizeProcessData anonymizationData) {
        return new ServiceOutcomeWithWarnings<ImmutableList>(ImmutableList.of(), new HashMap<String, ErrorCollection>());
    }

    @Override
    @Nonnull
    public AnonymizeUserService.AnonymizeOperation getAnonymizeOperation() {
        return AnonymizeUserService.AnonymizeOperation.USER_EXTERNAL_ID_CHANGE;
    }

    @Override
    public int getNumberOfTasks(@Nonnull AnonymizeUserService.AnonymizeValidationResult validationResult) {
        if (!validationResult.isValid()) {
            return 0;
        }
        AnonymizeUserService.AnonymizeProcessData processData = validationResult.getProcessData();
        if (!processData.handleOperation(AnonymizeUserService.AnonymizeOperation.USER_EXTERNAL_ID_CHANGE)) {
            return 0;
        }
        return 1;
    }
}

