/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.jira.config.FeatureFlag;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.AccessDisablingHelper;
import com.atlassian.jira.util.AccessDisablingHelperConfig;
import com.atlassian.jira.util.BuildUtilsInfo;
import com.atlassian.jira.util.BuildUtilsInfoImpl;
import com.atlassian.jira.util.Predicate;
import com.google.common.primitives.Ints;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessDisablingHelperImpl
implements AccessDisablingHelper {
    private final Map<String, Boolean> versionsComparisonCache = new ConcurrentHashMap<String, Boolean>();
    private final BuildUtilsInfo buildUtilsInfo;
    private final FeatureManager featureManager;
    private final JiraAuthenticationContext authContext;
    private final GlobalPermissionManager permissionManager;
    private Logger logger = LoggerFactory.getLogger(AccessDisablingHelperImpl.class);

    public AccessDisablingHelperImpl(BuildUtilsInfo buildUtilsInfo, FeatureManager featureManager, JiraAuthenticationContext authContext, GlobalPermissionManager permissionManager) {
        this.buildUtilsInfo = buildUtilsInfo;
        this.featureManager = featureManager;
        this.authContext = authContext;
        this.permissionManager = permissionManager;
    }

    @VisibleForTesting
    void setLogger(Logger logger) {
        this.logger = logger;
    }

    @Override
    public boolean canBeAccessedByCurrentUser(AccessDisablingHelperConfig config) {
        this.logDeprecationIfNecessary(config);
        if (!StringUtils.isBlank((CharSequence)config.getFeatureFlag())) {
            return this.featureManager.isEnabled(this.getFeatureFlag(config)) || this.areAccessConditionsMet(config);
        }
        return this.areAccessConditionsMet(config);
    }

    private void logDeprecationIfNecessary(AccessDisablingHelperConfig config) {
        if (config.getLogDeprecatedSince() != null && !StringUtils.isBlank((CharSequence)config.getFeatureFlag()) && this.isCurrentVersionHigherOrEqualTo(config.getLogDeprecatedSince()).booleanValue()) {
            this.logger.debug("Detected deprecated feature flag '{}'. It should be removed in version {}", (Object)config.getFeatureFlag(), (Object)config.getLogDeprecatedSince());
        }
    }

    private boolean areAccessConditionsMet(AccessDisablingHelperConfig config) {
        return !(config.isBlockAnonymous() && !this.authContext.isLoggedInUser() || config.getPermissionKey() != null && !this.permissionManager.hasPermission(config.getPermissionKey(), this.authContext.getLoggedInUser()) || this.isAdditionalConditionFulfilled(config) == false);
    }

    private FeatureFlag getFeatureFlag(AccessDisablingHelperConfig config) {
        FeatureFlag featureFlag = FeatureFlag.featureFlag((String)config.getFeatureFlag());
        if (this.shouldFeatureFlagBeEnabledByDefault(config)) {
            featureFlag = featureFlag.onByDefault();
        }
        return featureFlag;
    }

    private boolean shouldFeatureFlagBeEnabledByDefault(AccessDisablingHelperConfig config) {
        return config.getBlockAccessSince() != null && this.isCurrentVersionHigherOrEqualTo(config.getBlockAccessSince()) == false;
    }

    private Boolean isCurrentVersionHigherOrEqualTo(String version) {
        return this.versionsComparisonCache.computeIfAbsent(version, versionString -> Ints.lexicographicalComparator().compare((int[])BuildUtilsInfoImpl.parseVersion(version).first(), this.buildUtilsInfo.getVersionNumbers()) <= 0);
    }

    private Boolean isAdditionalConditionFulfilled(AccessDisablingHelperConfig config) {
        Predicate<ApplicationUser> condition = config.getAdditionalCondition();
        if (condition == null) {
            return true;
        }
        return condition.evaluate((Object)this.authContext.getLoggedInUser());
    }
}

