/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.EmailFormatter;
import com.opensymphony.util.TextUtils;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class EmailFormatterImpl
implements EmailFormatter {
    private final ApplicationProperties applicationProperties;
    private static final char SYMBOL_AT = '@';
    private static final char SYMBOL_DOT = '.';
    private static final String TEXT_AT = " at ";
    private static final String TEXT_DOT = " dot ";
    public static final String VISIBILITY_PUBLIC = "show";
    public static final String VISIBILITY_USER = "user";
    public static final String VISIBILITY_MASKED = "mask";
    public static final String VISIBILITY_HIDE = "hide";

    public EmailFormatterImpl(ApplicationProperties applicationProperties) {
        this.applicationProperties = applicationProperties;
    }

    public boolean emailVisible(ApplicationUser user) {
        String emailVisibility = this.applicationProperties.getString("jira.option.emailvisible");
        return VISIBILITY_PUBLIC.equals(emailVisibility) || VISIBILITY_MASKED.equals(emailVisibility) || VISIBILITY_USER.equals(emailVisibility) && user != null;
    }

    public String formatEmail(ApplicationUser user, ApplicationUser currentUser) {
        if (user != null) {
            return this.formatEmail(user.getEmailAddress(), currentUser);
        }
        return null;
    }

    public String formatEmail(String email, boolean isCurrentUserLoggedIn) {
        String emailVisibility = this.applicationProperties.getString("jira.option.emailvisible");
        if (!TextUtils.stringSet((String)emailVisibility)) {
            this.applicationProperties.setString("jira.option.emailvisible", VISIBILITY_PUBLIC);
            emailVisibility = VISIBILITY_PUBLIC;
        }
        if (VISIBILITY_PUBLIC.equals(emailVisibility) || VISIBILITY_USER.equals(emailVisibility) && isCurrentUserLoggedIn) {
            return email;
        }
        if (VISIBILITY_MASKED.equals(emailVisibility)) {
            StringBuilder result = new StringBuilder(email);
            result = this.replacePattern(result, '@', TEXT_AT);
            result = this.replacePattern(result, '.', TEXT_DOT);
            return result.toString();
        }
        return null;
    }

    public String formatEmail(String email, @Nullable ApplicationUser currentUser) {
        return this.formatEmail(email, currentUser != null);
    }

    @Nonnull
    public String formatEmailAsLink(String email, @Nullable ApplicationUser currentUser) {
        String emailVisibility = this.applicationProperties.getString("jira.option.emailvisible");
        if (VISIBILITY_PUBLIC.equals(emailVisibility) || VISIBILITY_USER.equals(emailVisibility) && currentUser != null) {
            return "<a href=\"mailto:" + TextUtils.htmlEncode((String)email) + "\">" + TextUtils.htmlEncode((String)this.formatEmail(email, currentUser)) + "</a>";
        }
        return TextUtils.htmlEncode((String)this.formatEmail(email, currentUser));
    }

    private StringBuilder replacePattern(StringBuilder stringBuilder, char originalChar, String replacementText) {
        if (stringBuilder == null || stringBuilder.length() < 1) {
            return stringBuilder;
        }
        for (int i = 0; i < stringBuilder.length(); ++i) {
            if (stringBuilder.charAt(i) != originalChar) continue;
            stringBuilder.replace(i, i + 1, replacementText);
        }
        return stringBuilder;
    }
}

