/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.net.NetworkUtils;
import java.net.UnknownHostException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JiraUtils {
    private static final Logger LOG = LoggerFactory.getLogger(JiraUtils.class);
    public static final String AM = "am";
    public static final String PM = "pm";

    public static boolean isPublicMode() {
        ApplicationProperties applicationProperties = ComponentAccessor.getApplicationProperties();
        String signupMode = applicationProperties.getString("jira.mode");
        boolean externalUsermanagement = applicationProperties.getOption("jira.option.user.externalmanagement");
        boolean publicMode = signupMode == null || signupMode.equals("public");
        return publicMode && !externalUsermanagement && ComponentAccessor.getUserManager().hasWritableDirectory();
    }

    public static int get24HourTime(String meridianIndicator, int hours) {
        if (hours == 12) {
            if (AM.equalsIgnoreCase(meridianIndicator)) {
                return 0;
            }
            if (PM.equalsIgnoreCase(meridianIndicator)) {
                return 12;
            }
        }
        int onceMeridianAdjustment = PM.equalsIgnoreCase(meridianIndicator) ? 12 : 0;
        return hours + onceMeridianAdjustment;
    }

    public static boolean isSetUp() {
        return ComponentAccessor.getApplicationProperties().getString("jira.setup") != null;
    }

    @Deprecated
    public static boolean isSetup() {
        return JiraUtils.isSetUp();
    }

    public static String getHostname() {
        try {
            return NetworkUtils.getLocalHostName();
        }
        catch (UnknownHostException e) {
            LOG.warn("IP/Hostname address cannot be calculated for this host. Please fix this.");
            return "0.0.0.0";
        }
    }
}

