/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util;

import com.atlassian.jira.util.dbc.Assertions;
import java.io.IOException;
import java.io.OutputStream;

public class LimitedOutputStream
extends OutputStream {
    private final OutputStream delegate;
    private final long maxLength;
    private long currentLength = 0L;

    public LimitedOutputStream(OutputStream delegate, long maxLength) {
        this.delegate = (OutputStream)Assertions.notNull((String)"delegate", (Object)delegate);
        this.maxLength = Assertions.nonNegative((String)"maxLength", (long)maxLength);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.checkLength(len);
        this.delegate.write(b, off, len);
    }

    @Override
    public void write(int b) throws IOException {
        this.checkLength(1);
        this.delegate.write(b);
    }

    public long getMaxLength() {
        return this.maxLength;
    }

    public long getCurrentLength() {
        return this.currentLength;
    }

    private void checkLength(int len) throws IOException {
        long nextLength = this.currentLength + (long)len;
        if (nextLength > this.maxLength) {
            throw new TooBigIOException(this.maxLength, this.currentLength, len);
        }
        this.currentLength = nextLength;
    }

    @Override
    public void flush() throws IOException {
        this.delegate.flush();
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }

    public static class TooBigIOException
    extends IOException {
        private final long maxSize;
        private final long currentSize;
        private final long writeLength;

        private TooBigIOException(long maxSize, long currentSize, long writeLength) {
            this.maxSize = maxSize;
            this.currentSize = currentSize;
            this.writeLength = writeLength;
        }

        public long getMaxSize() {
            return this.maxSize;
        }

        public long getCurrentSize() {
            return this.currentSize;
        }

        public long getNextSize() {
            return this.currentSize + this.writeLength;
        }

        public long getWriteLength() {
            return this.writeLength;
        }
    }
}

