/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util;

import com.atlassian.jira.util.MemoryPool;
import com.atlassian.jira.util.TextUtil;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.lang.management.MemoryUsage;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;

public class MemoryPools {
    public static List<MemoryPool> getMemoryPools() {
        List<MemoryPoolMXBean> memoryPoolMXBeans = ManagementFactory.getMemoryPoolMXBeans();
        ArrayList<MemoryPool> memoryPools = new ArrayList<MemoryPool>(memoryPoolMXBeans.size());
        for (MemoryPoolMXBean memoryPoolMXBean : memoryPoolMXBeans) {
            MemoryUsage memoryUsage = memoryPoolMXBean.getUsage();
            MemoryPool memoryPool = new MemoryPool(memoryPoolMXBean.getName(), memoryUsage.getUsed(), memoryUsage.getCommitted(), memoryUsage.getMax(), memoryPoolMXBean.getType());
            memoryPools.add(memoryPool);
        }
        return memoryPools;
    }

    public static String memoryPoolsDump(boolean detailByPool) {
        List<MemoryPool> pools = MemoryPools.getMemoryPools();
        EnumMap<MemoryType, PoolTotals> totalsByType = new EnumMap<MemoryType, PoolTotals>(MemoryType.class);
        for (MemoryType memoryType : MemoryType.values()) {
            totalsByType.put(memoryType, new PoolTotals());
        }
        PoolTotals totalMemory = new PoolTotals();
        Object poolsInfo = "";
        poolsInfo = (String)poolsInfo + "---------------------------------------------------------------------------------";
        for (MemoryPool pool : pools) {
            PoolTotals byType = (PoolTotals)totalsByType.get((Object)pool.getType());
            byType.add(pool);
            totalMemory.add(pool);
            if (!detailByPool) continue;
            poolsInfo = (String)poolsInfo + "\n  " + TextUtil.rpad(pool.getName(), 24) + ":  Used: " + MemoryPools.inMiB(pool.getUsed()) + ".  Committed: " + MemoryPools.inMiB(pool.getCommitted()) + ".  Max: " + MemoryPools.inMiB(pool.getMax());
        }
        if (detailByPool) {
            poolsInfo = (String)poolsInfo + "\n---------------------------------------------------------------------------------";
        }
        for (MemoryType memoryType : MemoryType.values()) {
            PoolTotals byType = (PoolTotals)totalsByType.get((Object)memoryType);
            poolsInfo = (String)poolsInfo + "\n  " + TextUtil.rpad(memoryType.toString(), 16) + ":  Used: " + MemoryPools.inMiB(byType.used) + ".  Committed: " + MemoryPools.inMiB(byType.committed) + ".  Max: " + MemoryPools.inMiB(byType.max);
        }
        poolsInfo = (String)poolsInfo + "\n---------------------------------------------------------------------------------";
        poolsInfo = (String)poolsInfo + "\n  " + TextUtil.rpad("TOTAL", 16) + ":  Used: " + MemoryPools.inMiB(totalMemory.used) + ".  Committed: " + MemoryPools.inMiB(totalMemory.committed) + ".  Max: " + MemoryPools.inMiB(totalMemory.max);
        poolsInfo = (String)poolsInfo + "\n---------------------------------------------------------------------------------";
        return poolsInfo;
    }

    public static String inMiB(long bytes) {
        if (bytes == -1L) {
            return "    -    ";
        }
        return TextUtil.lpad((bytes + 524288L) / 0x100000L + " MiB", 8);
    }

    static class PoolTotals {
        private long used = 0L;
        private long committed = 0L;
        private long max = 0L;

        PoolTotals() {
        }

        public void add(MemoryPool pool) {
            this.used += pool.getUsed();
            this.committed += pool.getCommitted();
            if (pool.getMax() > 0L) {
                this.max += pool.getMax();
            }
        }
    }
}

