/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.SelfUrlOriginType;
import java.net.URI;
import java.util.Objects;

public final class SelfUrlOriginTypeUtil {
    private SelfUrlOriginTypeUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static String getOrDefaultSelfUrlOriginType(ApplicationProperties applicationProperties) {
        String selfUrlOriginType = applicationProperties.getString("jira.self.url.origin.type");
        if (selfUrlOriginType == null) {
            selfUrlOriginType = SelfUrlOriginTypeUtil.setAndGetDefaultSelfUrlOriginType(applicationProperties);
        }
        return selfUrlOriginType;
    }

    public static URI getBaseUrl(ApplicationProperties applicationProperties) {
        return URI.create(Objects.requireNonNull(applicationProperties.getString("jira.baseurl")));
    }

    private static synchronized String setAndGetDefaultSelfUrlOriginType(ApplicationProperties applicationProperties) {
        String defaultSelfUrlOriginType = SelfUrlOriginType.getDefault().name();
        applicationProperties.setString("jira.self.url.origin.type", defaultSelfUrlOriginType);
        return defaultSelfUrlOriginType;
    }
}

