/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.io.ResourceLoader;
import com.atlassian.jira.util.json.JSONArray;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.descriptors.AbstractModuleDescriptor;
import com.atlassian.plugin.module.Element;
import com.atlassian.plugin.module.ModuleFactory;
import com.atlassian.plugin.web.Condition;
import com.atlassian.plugin.web.WebInterfaceManager;
import com.atlassian.plugin.web.api.conditions.ConditionLoadingException;
import com.atlassian.plugin.web.conditions.AlwaysDisplayCondition;
import com.atlassian.plugin.web.descriptors.ConditionElementParser;
import com.atlassian.plugin.web.descriptors.ConditionalDescriptor;
import com.google.common.base.Charsets;
import com.google.common.io.Resources;
import io.atlassian.fugue.Option;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;

public class WhisperMessageModuleDescriptor
extends AbstractModuleDescriptor<Void>
implements ConditionalDescriptor {
    private final ResourceLoader resourceLoader;
    private final ConditionElementParser conditionElementParser;
    private final WebInterfaceManager webInterfaceManager;
    private final List<JSONObject> messages;
    private final List<String> dependencies;
    private Element element;
    private Condition condition;

    @Inject
    public WhisperMessageModuleDescriptor(ModuleFactory moduleFactory, WebInterfaceManager webInterfaceManager) {
        super(moduleFactory);
        this.webInterfaceManager = webInterfaceManager;
        this.resourceLoader = (ResourceLoader)ComponentAccessor.getComponent(ResourceLoader.class);
        this.messages = new ArrayList<JSONObject>();
        this.dependencies = new ArrayList<String>();
        ConditionElementParser.ConditionFactory conditionFactory = (ConditionElementParser.ConditionFactory)ComponentAccessor.getComponent(ConditionElementParser.ConditionFactory.class);
        this.conditionElementParser = new ConditionElementParser((ConditionElementParser.ConditionFactory)(conditionFactory != null ? conditionFactory : new TemplateConditionFactory()));
    }

    public void init(Plugin plugin, Element element) throws PluginParseException {
        super.init(plugin, element);
        this.element = element;
    }

    public void enabled() {
        super.enabled();
        this.condition = this.conditionElementParser.makeConditions(this.plugin, this.element, 1);
        List messageElements = this.element.elements("message");
        for (Element messageElement : messageElements) {
            try {
                Option<URL> location = this.resourceLoader.getResource(this.plugin, messageElement.attributeValue("location"));
                if (location.isEmpty()) continue;
                String messagesJson = Resources.toString((URL)((URL)location.get()), (Charset)Charsets.UTF_8);
                JSONArray messages = new JSONArray(messagesJson);
                for (int i = 0; i < messages.length(); ++i) {
                    JSONObject messageJson = messages.getJSONObject(i);
                    this.messages.add(messageJson);
                }
            }
            catch (JSONException | IOException location) {
            }
        }
        List dependencyElements = this.element.elements("dependency");
        for (Element dependencyElement : dependencyElements) {
            this.dependencies.add(dependencyElement.getText());
        }
    }

    public Void getModule() {
        return null;
    }

    public List<JSONObject> getMessages() {
        return this.messages;
    }

    public List<String> getDependencies() {
        return this.dependencies;
    }

    public Condition getCondition() {
        return this.condition != null ? this.condition : new AlwaysDisplayCondition();
    }

    private class TemplateConditionFactory
    implements ConditionElementParser.ConditionFactory {
        private TemplateConditionFactory() {
        }

        public Condition create(String className, Plugin plugin) throws ConditionLoadingException {
            return WhisperMessageModuleDescriptor.this.webInterfaceManager.getWebFragmentHelper().loadCondition(className, plugin);
        }
    }
}

