/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util.cache;

import com.atlassian.jira.util.dbc.Assertions;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class WeakInterner<T> {
    private static final int DEFAULT_INITIAL_CAPACITY = 16;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private static final int DEFAULT_CONCURRENCY_LEVEL = 16;
    final ConcurrentMap<InternReference<T>, InternReference<T>> store;
    final ReferenceQueue<T> queue;

    public static <T> WeakInterner<T> newWeakInterner() {
        return new WeakInterner<T>();
    }

    public WeakInterner() {
        this(16, 0.75f, 16);
    }

    public WeakInterner(int initialCapacity) {
        this(initialCapacity, 0.75f, 16);
    }

    public WeakInterner(int initialCapacity, float loadFactor) {
        this(initialCapacity, loadFactor, 16);
    }

    public WeakInterner(int initialCapacity, float loadFactor, int concurrencyLevel) {
        this.store = new ConcurrentHashMap<InternReference<T>, InternReference<T>>(initialCapacity, loadFactor, concurrencyLevel);
        this.queue = new ReferenceQueue();
    }

    @Nonnull
    public T intern(@Nonnull T value) {
        return (T)this.internImpl(Assertions.notNull((String)"value", value));
    }

    @Nullable
    public T internOrNull(@Nullable T value) {
        return value != null ? (T)this.internImpl(value) : null;
    }

    public void cleanUp() {
        Reference<T> dead = this.queue.poll();
        while (dead != null) {
            this.store.remove(dead);
            dead = this.queue.poll();
        }
    }

    @Nonnull
    private T internImpl(@Nonnull T value) {
        this.cleanUp();
        InternReference<T> ref = new InternReference<T>(value, this.queue);
        InternReference<T> existing;
        while ((existing = this.store.putIfAbsent(ref, ref)) != null) {
            Object interned = existing.get();
            if (interned != null) {
                return interned;
            }
            this.store.remove(existing);
        }
        return value;
    }

    static final class InternReference<T>
    extends WeakReference<T> {
        private final int hash;

        InternReference(T value, ReferenceQueue<? super T> queue) {
            super(value, queue);
            this.hash = value.hashCode();
        }

        public boolean equals(Object obj) {
            return this == obj || obj instanceof InternReference && this.equals((InternReference)obj);
        }

        private boolean equals(@Nonnull InternReference<?> other) {
            Object value = this.get();
            return value != null && value.equals(other.get());
        }

        public int hashCode() {
            return this.hash;
        }

        public String toString() {
            return "InternReference@" + Integer.toHexString(System.identityHashCode(this)) + "[hash=" + this.hash + ",referent=" + this.get() + "]";
        }
    }
}

