/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util.collect;

import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterables;
import io.atlassian.util.concurrent.ManagedLock;
import io.atlassian.util.concurrent.ManagedLocks;
import java.util.AbstractSequentialList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.SortedSet;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;

public class CopyOnWriteSortedCache<T extends Comparable<T>>
implements Iterable<T> {
    private volatile SortedSet<T> set;
    private final ManagedLock lock = ManagedLocks.manage((Lock)new ReentrantLock());

    public CopyOnWriteSortedCache(Iterable<T> elements) {
        this.set = ImmutableSortedSet.copyOf((Iterable)((Iterable)Assertions.notNull((String)"elements", elements)));
    }

    public T add(T t) {
        Assertions.notNull((String)"element", t);
        return (T)((Comparable)this.lock.withLock(new Supplier<T>(){
            final /* synthetic */ Comparable val$t;
            {
                this.val$t = comparable;
            }

            @Override
            public T get() {
                CopyOnWriteSortedCache.this.set = ImmutableSortedSet.naturalOrder().addAll(CopyOnWriteSortedCache.this.set).add((Object)this.val$t).build();
                return this.val$t;
            }
        }));
    }

    public void remove(T t) {
        Assertions.notNull((String)"element", t);
        this.lock.withLock(new Runnable(){
            final /* synthetic */ Comparable val$t;
            {
                this.val$t = comparable;
            }

            @Override
            public void run() {
                CopyOnWriteSortedCache.this.set = ImmutableSortedSet.naturalOrder().addAll(Iterables.filter(CopyOnWriteSortedCache.this.set, (Predicate)new Predicate<T>(){

                    public boolean apply(T input) {
                        return !val$t.equals(input);
                    }
                })).build();
            }
        });
    }

    public void replaceAll(final Iterable<T> elements) {
        this.lock.withLock(new Runnable(){

            @Override
            public void run() {
                CopyOnWriteSortedCache.this.set = ImmutableSortedSet.copyOf((Iterable)elements);
            }
        });
    }

    public List<T> asList() {
        return new SetBackedList<T>(this.set);
    }

    public SortedSet<T> asSortedSet() {
        return this.set;
    }

    @Override
    public Iterator<T> iterator() {
        return this.set.iterator();
    }

    static class SetBackedList<T>
    extends AbstractSequentialList<T> {
        private final SortedSet<T> set;

        SetBackedList(SortedSet<T> set) {
            this.set = set;
        }

        @Override
        public T get(int index) {
            return (T)Iterables.get(this.set, (int)index);
        }

        @Override
        public int size() {
            return this.set.size();
        }

        @Override
        public Iterator<T> iterator() {
            return this.set.iterator();
        }

        @Override
        public ListIterator<T> listIterator() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ListIterator<T> listIterator(int index) {
            throw new UnsupportedOperationException();
        }
    }
}

