/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util.concurrent;

import java.time.Duration;
import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public final class ScheduledExecutorServiceUtils {
    private ScheduledExecutorServiceUtils() {
    }

    public static ScheduledFuture<?> scheduleWithVariableDelay(final ScheduledExecutorService scheduler, final Runnable command, Duration initialDelay, Duration maximumDelay) {
        if (initialDelay.isNegative()) {
            initialDelay = Duration.ZERO;
        }
        final long maximumDelayNanos = maximumDelay.toNanos();
        final ScheduledFutureImpl myScheduledFuture = new ScheduledFutureImpl(initialDelay);
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (myScheduledFuture.isCancelled()) {
                    return;
                }
                long startTime = System.nanoTime();
                try {
                    command.run();
                }
                finally {
                    if (!myScheduledFuture.isCancelled()) {
                        long elapsedNanos = System.nanoTime() - startTime;
                        long delay = Math.max(0L, maximumDelayNanos - elapsedNanos);
                        myScheduledFuture.updateTriggerTime(delay);
                        scheduler.schedule(this, delay, TimeUnit.NANOSECONDS);
                    }
                }
            }
        };
        myScheduledFuture.setRunnable(runnable);
        scheduler.schedule(runnable, initialDelay.toNanos(), TimeUnit.NANOSECONDS);
        return myScheduledFuture;
    }

    private static class ScheduledFutureImpl
    implements ScheduledFuture<Object> {
        private volatile long triggerTime;
        private volatile FutureTask<Void> futureTask;

        private ScheduledFutureImpl(Duration initialDelay) {
            this.updateTriggerTime(initialDelay.toNanos());
        }

        private void updateTriggerTime(long delay) {
            this.triggerTime = System.nanoTime() + delay;
        }

        @Override
        public long getDelay(TimeUnit unit) {
            return unit.convert(this.triggerTime - System.nanoTime(), TimeUnit.NANOSECONDS);
        }

        @Override
        public int compareTo(Delayed o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return this.futureTask.cancel(mayInterruptIfRunning);
        }

        @Override
        public boolean isCancelled() {
            return this.futureTask.isCancelled();
        }

        @Override
        public boolean isDone() {
            return this.futureTask.isDone();
        }

        @Override
        public Object get() throws InterruptedException, ExecutionException {
            return this.futureTask.get();
        }

        @Override
        public Object get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.futureTask.get(timeout, unit);
        }

        public void setRunnable(Runnable scheduledFuture) {
            this.futureTask = new FutureTask<Object>(scheduledFuture, null);
        }
    }
}

