/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util.map;

import java.io.Serializable;

public class CacheObject<T>
implements Serializable {
    private final T value;
    public static final CacheObject NULL_INSTANCE = new CacheObject<Object>(null);

    public static <T> CacheObject<T> NULL() {
        return NULL_INSTANCE;
    }

    public static <T> CacheObject<T> wrap(T object) {
        return object == null ? CacheObject.NULL() : new CacheObject<T>(object);
    }

    public CacheObject(T value) {
        this.value = value;
    }

    public T getValue() {
        return this.value;
    }

    public boolean hasValue() {
        return this.value != null;
    }

    public boolean isNull() {
        return this.value == null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CacheObject)) {
            return false;
        }
        CacheObject cacheObject = (CacheObject)o;
        return !(this.value != null ? !this.value.equals(cacheObject.value) : cacheObject.value != null);
    }

    public int hashCode() {
        return this.value != null ? this.value.hashCode() : 0;
    }

    public String toString() {
        return this.value != null ? "CacheObject{" + this.value + "}" : "CacheObject.NULL";
    }
}

