/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util.resourcebundle;

import com.atlassian.jira.plugin.language.Language;
import com.atlassian.jira.plugin.language.LanguageModuleDescriptor;
import com.atlassian.jira.util.resourcebundle.DefaultResourceBundle;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.Resources;
import com.atlassian.plugin.elements.ResourceDescriptor;
import com.atlassian.plugin.metadata.PluginMetadataManager;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.function.Predicate;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
class PluginResourceLoaderInvocation {
    private static final Logger log = LoggerFactory.getLogger(PluginResourceLoaderInvocation.class);
    private static final int INITIAL_FLATTENED_MAP_SIZE = 8192;
    private final PluginAccessor accessor;
    private final PluginMetadataManager pluginMetadata;
    private final Function<Locale, Iterable<ResourceBundle>> defaultLanguage;
    private final BundleLoader bundleLoader;
    private final Resources.TypeFilterPredicate filter;
    private final boolean includeLanaguagePacks;
    private final Locale locale;
    private final Predicate<ResourceBundle> includeResourceBundleFilter;

    PluginResourceLoaderInvocation(PluginAccessor accessor, PluginMetadataManager pluginMetadata, Resources.TypeFilterPredicate filter, boolean includeLanaguagePacks, Locale locale) {
        this(accessor, pluginMetadata, new DefaultLanguageSupplierImpl(), new DefaultBundleLoader(), filter, includeLanaguagePacks, locale, rb -> true);
    }

    PluginResourceLoaderInvocation(PluginAccessor accessor, PluginMetadataManager pluginMetadata, Resources.TypeFilterPredicate filter, boolean includeLanaguagePacks, Locale locale, Predicate<ResourceBundle> includeResourceBundleFilter) {
        this(accessor, pluginMetadata, new DefaultLanguageSupplierImpl(), new DefaultBundleLoader(), filter, includeLanaguagePacks, locale, includeResourceBundleFilter);
    }

    @VisibleForTesting
    PluginResourceLoaderInvocation(PluginAccessor accessor, PluginMetadataManager pluginMetadata, DefaultLanguageSupplier defaultLanguage, BundleLoader loader, Resources.TypeFilterPredicate filter, boolean includeLanaguagePacks, Locale locale, Predicate<ResourceBundle> includeResourceBundleFilter) {
        this.accessor = accessor;
        this.pluginMetadata = pluginMetadata;
        this.defaultLanguage = defaultLanguage;
        this.bundleLoader = loader;
        this.filter = filter;
        this.includeLanaguagePacks = includeLanaguagePacks;
        this.locale = locale;
        this.includeResourceBundleFilter = includeResourceBundleFilter;
    }

    private static boolean providedLocaleMatches(Locale providedLocale, Locale targetLocale) {
        if (providedLocale.getLanguage().length() == 0) {
            return true;
        }
        if (!providedLocale.getLanguage().equals(targetLocale.getLanguage())) {
            return false;
        }
        if (providedLocale.getCountry().length() == 0) {
            return true;
        }
        return providedLocale.getCountry().equals(targetLocale.getCountry());
    }

    private static void logFlatteningException(String key, ResourceBundle bundle, Exception e) {
        if (log.isDebugEnabled()) {
            log.debug("Failed to resolve key " + key + "  from resource bundle " + bundle + ": " + e, (Throwable)e);
        }
    }

    public Map<String, String> load() {
        Iterable translations = this.loadPluginSourcedBundles();
        if (this.includeLanaguagePacks) {
            translations = Iterables.concat(translations, (Iterable)((Iterable)this.defaultLanguage.apply((Object)this.locale)), this.loadV2LanguagePackBundles());
        }
        return this.flattenResourceBundlesToMap(Iterables.filter(translations, (com.google.common.base.Predicate)Predicates.notNull()));
    }

    private ImmutableMap<String, String> flattenResourceBundlesToMap(Iterable<ResourceBundle> bundles) {
        HashMap<String, String> map = new HashMap<String, String>(8192);
        for (ResourceBundle bundle : bundles) {
            this.logBundleLoadedMessage(bundle);
            Enumeration<String> keys = bundle.getKeys();
            while (keys.hasMoreElements()) {
                String propertyKey = keys.nextElement();
                if (propertyKey == null) continue;
                try {
                    String value = bundle.getString(propertyKey);
                    if (value == null) continue;
                    map.put(propertyKey.intern(), value.intern());
                }
                catch (RuntimeException e) {
                    PluginResourceLoaderInvocation.logFlatteningException(propertyKey, bundle, e);
                }
            }
        }
        return ImmutableMap.copyOf(map);
    }

    private void logBundleLoadedMessage(ResourceBundle bundle) {
        if (log.isDebugEnabled()) {
            String name;
            try {
                Field bundleNameField = ResourceBundle.class.getDeclaredField("name");
                bundleNameField.setAccessible(true);
                name = (String)bundleNameField.get(bundle);
            }
            catch (Exception e) {
                name = String.valueOf(bundle);
            }
            log.debug(String.format("Adding ResourceBundle: %s bundle; Locale: %s; Mode: %s; %d keys.", name, bundle.getLocale(), this.getModeString(), bundle.keySet().size()));
        }
    }

    private String getModeString() {
        return "filter=" + this.filter + " includeLanguagePacks=" + this.includeLanaguagePacks;
    }

    private Iterable<ResourceBundle> loadV2LanguagePackBundles() {
        ArrayList<ResourceBundle> v2LanguagePacks = new ArrayList<ResourceBundle>();
        List descriptors = this.accessor.getEnabledModuleDescriptorsByClass(LanguageModuleDescriptor.class);
        for (LanguageModuleDescriptor descriptor : descriptors) {
            this.addV2LanguagePackBundle(v2LanguagePacks, descriptor);
        }
        Collections.sort(v2LanguagePacks, ResourceBundleLocaleSorter.INSTANCE);
        return v2LanguagePacks;
    }

    private void addV2LanguagePackBundle(List<ResourceBundle> v2LanguagePacks, LanguageModuleDescriptor descriptor) {
        block13: {
            try {
                Locale providedLocale = ((Language)descriptor.getModule()).getLocale();
                if (PluginResourceLoaderInvocation.providedLocaleMatches(providedLocale, this.locale)) {
                    ResourceBundle resourceBundle = this.bundleLoader.getBundle(descriptor);
                    v2LanguagePacks.add(resourceBundle);
                    Iterable i18nResources = Iterables.filter((Iterable)descriptor.getPlugin().getResourceDescriptors(), arg_0 -> ((Resources.TypeFilterPredicate)this.filter).test(arg_0));
                    for (ResourceDescriptor resourceDescriptor : i18nResources) {
                        try {
                            v2LanguagePacks.add(this.bundleLoader.getBundle(this.locale, descriptor.getPlugin(), resourceDescriptor));
                        }
                        catch (MissingResourceException e) {
                            if (!log.isDebugEnabled()) continue;
                            log.debug(String.format("FAILED plugin resource; targetLocale: %s; pluginKey: %s; location: %s; mode:%s", this.locale, descriptor.getPluginKey(), resourceDescriptor.getLocation(), this.getModeString()));
                        }
                    }
                    if (log.isDebugEnabled()) {
                        log.debug("Accepted v2 lang pack; targetLocale=" + this.locale + "; descriptor=" + descriptor.getCompleteKey() + "; providedLocale=" + providedLocale);
                    }
                } else if (log.isDebugEnabled()) {
                    log.debug("IGNORING v2 lang pack; targetLocale=" + this.locale + "; descriptor=" + descriptor.getCompleteKey() + "; providedLocale=" + providedLocale);
                }
            }
            catch (MissingResourceException mre) {
                if (log.isDebugEnabled()) {
                    log.debug("Missing resource for v2 lang pack; targetLocale=" + this.locale + "; descriptor=" + descriptor.getCompleteKey() + "; ");
                }
            }
            catch (RuntimeException re) {
                Object descriptorKey;
                if (!log.isDebugEnabled()) break block13;
                try {
                    descriptorKey = descriptor.getCompleteKey();
                }
                catch (RuntimeException ex) {
                    descriptorKey = "<" + ex + ">";
                }
                log.debug("FAILED v2 lang pack; targetLocale=" + this.locale + "; descriptor=" + (String)descriptorKey + "; ", (Throwable)re);
            }
        }
    }

    private Iterable<ResourceBundle> loadPluginSourcedBundles() {
        ArrayList pluginBundles = Lists.newArrayList();
        ArrayList enabledPlugins = Lists.newArrayList((Iterable)this.accessor.getEnabledPlugins());
        Ordering ordering = Ordering.from((Comparator)PluginLanguagePackSorter.INSTANCE);
        if (!this.includeLanaguagePacks) {
            ordering = ordering.compound((Comparator)Ordering.natural().reverse().onResultOf((Function)new Function<Plugin, Boolean>(){

                public Boolean apply(Plugin input) {
                    return PluginResourceLoaderInvocation.this.pluginMetadata.isSystemProvided(input);
                }
            }));
        }
        Collections.sort(enabledPlugins, ordering);
        for (Plugin plugin : enabledPlugins) {
            try {
                this.loadPluginSourcedBundles(pluginBundles, plugin);
            }
            catch (RuntimeException re) {
                if (!log.isDebugEnabled()) continue;
                log.debug(String.format("FAILED plugin resources: targetLocale: %s; pluginKey: %s; mode: %s", this.locale, plugin.getKey(), this.getModeString()), (Throwable)re);
            }
        }
        Collections.sort(pluginBundles, ResourceBundleLocaleSorter.INSTANCE);
        return pluginBundles;
    }

    private void loadPluginSourcedBundles(List<ResourceBundle> pluginBundles, Plugin plugin) {
        for (ResourceDescriptor resourceDescriptor : this.getResourceBundleLocations(plugin)) {
            try {
                this.loadPluginSourcedBundle(pluginBundles, plugin, resourceDescriptor);
            }
            catch (RuntimeException re) {
                log.debug(String.format("FAILED plugin resource; targetLocale: %s; pluginKey: %s; descriptor: <toxic>; mode: %s", this.locale, plugin.getKey(), this.getModeString()), (Throwable)re);
            }
        }
    }

    private void loadPluginSourcedBundle(List<ResourceBundle> pluginBundles, Plugin plugin, ResourceDescriptor descriptor) {
        try {
            ResourceBundle resourceBundle = this.bundleLoader.getBundle(this.locale, plugin, descriptor);
            if (PluginResourceLoaderInvocation.providedLocaleMatches(resourceBundle.getLocale(), this.locale) && this.includeResourceBundleFilter.test(resourceBundle)) {
                if (log.isDebugEnabled()) {
                    log.debug(String.format("Accepted plugin resource; targetLocale: %s; pluginKey: %s; descriptor: %s; mode: %s", this.locale, plugin.getKey(), descriptor.getLocation(), this.getModeString()));
                }
                pluginBundles.add(resourceBundle);
            } else if (log.isDebugEnabled()) {
                log.debug(String.format("IGNORING plugin resource; targetLocale: %s; pluginKey: %s; descriptor: %s; mode: %s", this.locale, plugin.getKey(), descriptor.getLocation(), this.getModeString()));
            }
        }
        catch (MissingResourceException mre) {
            log.debug(String.format("FAILED plugin resource; targetLocale: %s; pluginKey: %s; location: %s; mode:%s", this.locale, plugin.getKey(), descriptor.getLocation(), this.getModeString()));
        }
    }

    private Collection<ResourceDescriptor> getResourceBundleLocations(Plugin plugin) {
        ArrayList locations = Lists.newArrayList();
        Iterables.addAll((Collection)locations, (Iterable)Iterables.filter((Iterable)plugin.getResourceDescriptors(), arg_0 -> ((Resources.TypeFilterPredicate)this.filter).test(arg_0)));
        for (ModuleDescriptor moduleDescriptor : plugin.getModuleDescriptors()) {
            try {
                Iterables.addAll((Collection)locations, (Iterable)Iterables.filter((Iterable)moduleDescriptor.getResourceDescriptors(), arg_0 -> ((Resources.TypeFilterPredicate)this.filter).test(arg_0)));
            }
            catch (RuntimeException re) {
                if (!log.isDebugEnabled()) continue;
                log.debug(String.format("FAILED plugin module resource descriptors: pluginKey: %s; moduleKey: %s; mode: %s", plugin.getKey(), moduleDescriptor.getCompleteKey(), this.getModeString()), (Throwable)re);
            }
        }
        return locations;
    }

    private static class DefaultLanguageSupplierImpl
    implements DefaultLanguageSupplier {
        private DefaultLanguageSupplierImpl() {
        }

        public Iterable<ResourceBundle> apply(Locale input) {
            return Collections.singletonList(DefaultResourceBundle.getDefaultResourceBundle(input));
        }
    }

    private static class DefaultBundleLoader
    implements BundleLoader {
        private static final ResourceBundle.Control NO_FALLBACK_CONTROL = ResourceBundle.Control.getNoFallbackControl(ResourceBundle.Control.FORMAT_PROPERTIES);

        private DefaultBundleLoader() {
        }

        @Override
        public ResourceBundle getBundle(Locale targetLocale, Plugin plugin, ResourceDescriptor descriptor) {
            return ResourceBundle.getBundle(descriptor.getLocation(), targetLocale, plugin.getClassLoader(), NO_FALLBACK_CONTROL);
        }

        @Override
        public ResourceBundle getBundle(LanguageModuleDescriptor descriptor) {
            return ResourceBundle.getBundle(descriptor.getResourceBundleName(), ((Language)descriptor.getModule()).getLocale(), descriptor.getPlugin().getClassLoader(), NO_FALLBACK_CONTROL);
        }
    }

    static interface DefaultLanguageSupplier
    extends Function<Locale, Iterable<ResourceBundle>> {
    }

    static interface BundleLoader {
        public ResourceBundle getBundle(Locale var1, Plugin var2, ResourceDescriptor var3);

        public ResourceBundle getBundle(LanguageModuleDescriptor var1);
    }

    @Immutable
    private static final class ResourceBundleLocaleSorter
    implements Comparator<ResourceBundle> {
        private static final ResourceBundleLocaleSorter INSTANCE = new ResourceBundleLocaleSorter();

        private ResourceBundleLocaleSorter() {
        }

        @Override
        public int compare(ResourceBundle bundle1, ResourceBundle bundle2) {
            Locale locale1 = bundle1.getLocale();
            Locale locale2 = bundle2.getLocale();
            if (locale1.getLanguage().length() == 0) {
                return locale2.getLanguage().length() == 0 ? 0 : -1;
            }
            if (locale2.getLanguage().length() == 0) {
                return 1;
            }
            if (locale1.getCountry().length() == 0) {
                return locale2.getCountry().length() == 0 ? 0 : -1;
            }
            if (locale2.getCountry().length() == 0) {
                return 1;
            }
            return 0;
        }
    }

    @Immutable
    private static final class PluginLanguagePackSorter
    implements Comparator<Plugin> {
        static final PluginLanguagePackSorter INSTANCE = new PluginLanguagePackSorter();

        private PluginLanguagePackSorter() {
        }

        private static boolean isLanguagePack(Plugin plugin) {
            return !plugin.getModuleDescriptorsByModuleClass(LanguageModuleDescriptor.class).isEmpty();
        }

        @Override
        public int compare(Plugin plugin1, Plugin plugin2) {
            boolean isPlugin1LanguagePack = PluginLanguagePackSorter.isLanguagePack(plugin1);
            boolean isPlugin2LanguagePack = PluginLanguagePackSorter.isLanguagePack(plugin2);
            if (isPlugin1LanguagePack) {
                return isPlugin2LanguagePack ? 0 : 1;
            }
            return isPlugin2LanguagePack ? -1 : 0;
        }
    }
}

