/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util.stats;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.analytics.AnalyticsEvent;
import com.atlassian.jira.analytics.AnalyticsSender;
import com.atlassian.jira.util.stats.JiraStats;
import com.atlassian.jira.util.stats.ManagedStats;
import com.atlassian.jira.util.stats.NotifiesOnClose;
import com.atlassian.jira.util.stats.RequestAwareStats;
import com.atlassian.jira.util.stats.RequestAwareStatsRegistrar;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Supplier;

public class AtlassianStatsFactory {
    private AtlassianStatsFactory() {
    }

    public static <M extends ManagedStats & RequestAwareStats> M create(RequestAwareStatsRegistrar requestAwareStatsRegistrar, Class<M> interfaceClass, Supplier<M> objectFactory, boolean printOnSeparateThread, EventPublisher eventPublisher, BiFunction<Map, Map, AnalyticsEvent> analyticEventCreator) {
        ManagedStats jiraStats = JiraStats.create(interfaceClass, objectFactory, (boolean)printOnSeparateThread);
        requestAwareStatsRegistrar.registerListener((RequestAwareStats)jiraStats);
        ((NotifiesOnClose)jiraStats).registerOnCloseListener(() -> requestAwareStatsRegistrar.unregisterListener((RequestAwareStats)jiraStats));
        AnalyticsSender.registerAnalyticsSender(jiraStats, eventPublisher, analyticEventCreator);
        return (M)jiraStats;
    }
}

