/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util.stats;

import com.atlassian.jira.util.stats.ManagedStats;
import com.atlassian.jira.util.stats.MutableDoubleStats;
import com.atlassian.jira.util.stats.MutableLongStats;
import com.atlassian.jira.util.stats.NotifiesOnClose;
import com.atlassian.jira.util.stats.RequestAwareStats;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RequestAwareManagedStats
implements ManagedStats,
RequestAwareStats,
NotifiesOnClose {
    private static final Logger log = LoggerFactory.getLogger(RequestAwareManagedStats.class);
    private final transient ThreadLocal<Long> allRequestOperationsMicrosThreadLocal = ThreadLocal.withInitial(() -> 0L);
    @VisibleForTesting
    protected final MutableLongStats requestMillis = new MutableLongStats(new long[]{TimeUnit.MILLISECONDS.toMillis(5L), TimeUnit.MILLISECONDS.toMillis(10L), TimeUnit.MILLISECONDS.toMillis(100L), TimeUnit.SECONDS.toMillis(1L), TimeUnit.SECONDS.toMillis(5L), TimeUnit.SECONDS.toMillis(10L)});
    @VisibleForTesting
    protected final MutableLongStats allMeasuredOperationsMicros = new MutableLongStats(new long[]{TimeUnit.MICROSECONDS.toMicros(100L), TimeUnit.MILLISECONDS.toMicros(1L), TimeUnit.MILLISECONDS.toMicros(10L)});
    @VisibleForTesting
    protected final MutableDoubleStats measuredOperationsAsRequestFraction = new MutableDoubleStats(new double[]{0.01, 0.05, 0.1, 0.2, 0.5});
    private final transient List<Runnable> onCloseListeners = Collections.synchronizedList(new ArrayList());

    @Override
    public void registerOnCloseListener(Runnable runOnClose) {
        this.onCloseListeners.add(runOnClose);
    }

    public void close() throws IOException {
        this.onCloseListeners.stream().map(this::runSafely).forEach(Runnable::run);
        this.onCloseListeners.clear();
        super.close();
    }

    @Override
    public final void onRequestStarted() {
        this.allRequestOperationsMicrosThreadLocal.remove();
    }

    @Override
    public final void onRequestFinished(long requestTimeMicros) {
        this.requestMillis.accept(TimeUnit.MICROSECONDS.toMillis(requestTimeMicros));
        Long measuredOperationsMicros = this.allRequestOperationsMicrosThreadLocal.get();
        if (measuredOperationsMicros > 0L) {
            this.allMeasuredOperationsMicros.accept(measuredOperationsMicros.longValue());
            double fractionOfRequest = (double)measuredOperationsMicros.longValue() / (double)requestTimeMicros;
            this.measuredOperationsAsRequestFraction.accept(fractionOfRequest);
        }
    }

    protected final void addToRequestMarkup(long micros) {
        this.allRequestOperationsMicrosThreadLocal.set(this.allRequestOperationsMicrosThreadLocal.get() + micros);
    }

    private Runnable runSafely(Runnable runnable) {
        return () -> {
            try {
                runnable.run();
            }
            catch (Exception e) {
                log.error("Failed running onCloseListener", (Throwable)e);
            }
        };
    }
}

