/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util.stats;

import com.atlassian.jira.util.stats.RequestAwareStats;
import com.atlassian.jira.util.stats.RequestAwareStatsRegistrar;
import com.atlassian.jira.util.stats.RequestLifecycleStepReceiver;
import com.google.common.annotations.VisibleForTesting;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.LongSupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestAwareStatsManager
implements RequestLifecycleStepReceiver,
RequestAwareStatsRegistrar {
    private static final Logger log = LoggerFactory.getLogger(RequestAwareStatsManager.class);
    private final Map<RequestAwareStats, ExceptionSafeRequestAwareStats> listeners = new ConcurrentHashMap<RequestAwareStats, ExceptionSafeRequestAwareStats>();
    private final ThreadLocal<Integer> currentThreadRequestNestingLevel = ThreadLocal.withInitial(() -> 0);
    private final ThreadLocal<Long> currentThreadRequestStartTime = new ThreadLocal();
    private final LongSupplier nanoTimeSupplier;

    public RequestAwareStatsManager() {
        this(System::nanoTime);
    }

    @VisibleForTesting
    RequestAwareStatsManager(LongSupplier nanoTimeSupplier) {
        this.nanoTimeSupplier = nanoTimeSupplier;
    }

    @Override
    public void registerListener(RequestAwareStats stats) {
        this.listeners.put(stats, new ExceptionSafeRequestAwareStats(stats));
    }

    @Override
    public void unregisterListener(RequestAwareStats stats) {
        this.listeners.remove(stats);
    }

    @Override
    public void requestStarted() {
        Integer i = this.currentThreadRequestNestingLevel.get();
        if (i == 0) {
            this.currentThreadRequestStartTime.set(this.nanoTimeSupplier.getAsLong());
            this.listeners.values().forEach(RequestAwareStats::onRequestStarted);
        }
        this.currentThreadRequestNestingLevel.set(i + 1);
    }

    @Override
    public void requestFinished() {
        Integer i = this.currentThreadRequestNestingLevel.get();
        if (i == 1) {
            long requestStartTime = this.currentThreadRequestStartTime.get();
            long requestEndTime = this.nanoTimeSupplier.getAsLong();
            this.currentThreadRequestStartTime.remove();
            long requestTimeMicros = TimeUnit.NANOSECONDS.toMicros(requestEndTime - requestStartTime);
            this.listeners.values().forEach(l -> l.onRequestFinished(requestTimeMicros));
        }
        if (i > 0) {
            this.currentThreadRequestNestingLevel.set(i - 1);
        } else {
            this.currentThreadRequestNestingLevel.remove();
            this.currentThreadRequestStartTime.remove();
        }
    }

    private static final class ExceptionSafeRequestAwareStats
    implements RequestAwareStats {
        private final RequestAwareStats delegate;

        private ExceptionSafeRequestAwareStats(RequestAwareStats delegate) {
            this.delegate = delegate;
        }

        @Override
        public void onRequestStarted() {
            try {
                this.delegate.onRequestStarted();
            }
            catch (Exception e) {
                log.error("Failed calling onRequestStarted for listener {}", (Object)this.delegate, (Object)e);
            }
        }

        @Override
        public void onRequestFinished(long requestTimeMicros) {
            try {
                this.delegate.onRequestFinished(requestTimeMicros);
            }
            catch (Exception e) {
                log.error("Failed calling onRequestFinished for listener {}", (Object)this.delegate, (Object)e);
            }
        }
    }
}

