/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util.system.check;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.ofbiz.OfBizConnectionFactory;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.util.system.check.I18nMessage;
import com.atlassian.jira.util.system.check.SystemEnvironmentCheck;
import com.atlassian.jira.web.util.HelpUtil;
import com.google.common.annotations.VisibleForTesting;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.ofbiz.core.entity.config.JndiDatasourceInfo;

public class JRA15731Check
implements SystemEnvironmentCheck {
    private final OfBizConnectionFactory factory;

    JRA15731Check(OfBizConnectionFactory factory) {
        this.factory = (OfBizConnectionFactory)Assertions.notNull((Object)factory);
    }

    public JRA15731Check() {
        this((OfBizConnectionFactory)ComponentAccessor.getComponent(OfBizConnectionFactory.class));
    }

    public String getName() {
        return "MySQL Validation Query Check";
    }

    @Override
    public I18nMessage getWarningMessage() {
        if (this.isMySQL() && !this.hasValidationQuery()) {
            HelpUtil helpUtil = new HelpUtil();
            I18nMessage warning = new I18nMessage("admin.warning.JRA15731.syscheck");
            warning.setLink(helpUtil.getHelpPath("JRA15731").getUrl());
            return warning;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    boolean isMySQL() {
        Connection connection = null;
        try {
            connection = this.factory.getConnection();
            DatabaseMetaData dbMeta = connection.getMetaData();
            boolean bl = dbMeta.getDatabaseProductName().equals("MySQL");
            return bl;
        }
        catch (SQLException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.silentlyClose(connection);
        }
    }

    private boolean hasValidationQuery() {
        JndiDatasourceInfo jndi = this.factory.getDatasourceInfo().getJndiDatasource();
        if (jndi != null) {
            try {
                InitialContext initCtx = new InitialContext();
                Object resource = initCtx.lookup(jndi.getJndiName());
                if (!(resource instanceof DataSource)) {
                    return true;
                }
                for (Method method : resource.getClass().getMethods()) {
                    if (!method.getName().equals("getValidationQuery")) continue;
                    try {
                        String validationQuery = (String)method.invoke(resource, new Object[0]);
                        return validationQuery != null;
                    }
                    catch (IllegalAccessException e) {
                        return true;
                    }
                    catch (InvocationTargetException e) {
                        return true;
                    }
                }
                return true;
            }
            catch (NamingException e) {
                return true;
            }
        }
        return true;
    }

    private void silentlyClose(Connection connection) {
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }
}

