/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util.system.patch;

import com.atlassian.jira.util.IOUtil;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.util.system.patch.AppliedPatchInfo;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AppliedPatchFinder {
    private static final String ANCHOR_FILENAME = "patching_jira.readme";
    private static final String PATCHES_CLASS_PATH = "/patches/";
    private static final Logger log = LoggerFactory.getLogger(AppliedPatchFinder.class);

    AppliedPatchFinder() {
    }

    Set<AppliedPatchInfo> getAppliedPatches() {
        File patchAnchor = this.findPatchFileAnchor();
        if (patchAnchor == null) {
            return Collections.emptySet();
        }
        return this.findAppliedPatches(patchAnchor);
    }

    File findPatchFileAnchor() {
        URL patchReadMe = this.findPatchFileURL();
        if (patchReadMe != null) {
            if (patchReadMe.getProtocol().equals("file")) {
                try {
                    File f = new File(patchReadMe.toURI());
                    if (f.exists()) {
                        return f;
                    }
                }
                catch (URISyntaxException e) {
                    log.error("This should never happen", (Throwable)e);
                }
            } else {
                log.warn("AppliedPatchFinder will be skipped because it can only work on simple files (not jars). patching_jira.readme URL = " + patchReadMe);
            }
        }
        return null;
    }

    URL findPatchFileURL() {
        return this.getClass().getResource("/patches/patching_jira.readme");
    }

    private Set<AppliedPatchInfo> findAppliedPatches(File patchAnchorFile) {
        File[] files;
        HashSet<AppliedPatchInfo> patches = new HashSet<AppliedPatchInfo>();
        File patchesDir = patchAnchorFile.getParentFile();
        for (File patchFile : files = patchesDir.listFiles()) {
            if (!this.validFile(patchFile)) continue;
            String issueKey = this.getKey(patchFile);
            String issueDesc = this.getDesc(patchFile);
            patches.add(new AppliedPatchInfoImpl(issueKey, issueDesc));
        }
        return patches;
    }

    private boolean validFile(File patchFile) {
        if (patchFile.isDirectory()) {
            return false;
        }
        String fileName = patchFile.getName();
        if (ANCHOR_FILENAME.equals(fileName)) {
            return false;
        }
        int lastIndex = fileName.lastIndexOf(".");
        return lastIndex != 0;
    }

    private String getKey(File patchFile) {
        String key = patchFile.getName();
        int lastIndex = key.lastIndexOf(".");
        if (lastIndex > 0) {
            key = key.substring(0, lastIndex);
        }
        return key;
    }

    private String getDesc(File patchFile) {
        try {
            StringWriter sw = new StringWriter();
            FileReader fr = new FileReader(patchFile);
            IOUtil.copy((Reader)fr, (Writer)sw);
            IOUtil.shutdownReader(fr);
            return sw.toString();
        }
        catch (FileNotFoundException e) {
            String message = "Could not find patch file : " + patchFile;
            log.error(message, (Throwable)e);
            return message;
        }
        catch (IOException e) {
            String message = "Could not read patch file : " + patchFile;
            log.error(message, (Throwable)e);
            return message;
        }
    }

    static class AppliedPatchInfoImpl
    implements AppliedPatchInfo,
    Comparable<AppliedPatchInfo> {
        private final String issueKey;
        private final String desc;

        public AppliedPatchInfoImpl(String issueKey, String desc) {
            this.issueKey = (String)Assertions.notNull((String)"issueKey", (Object)issueKey);
            this.desc = (String)Assertions.notNull((String)"issueDesc", (Object)desc);
        }

        @Override
        public String getIssueKey() {
            return this.issueKey;
        }

        @Override
        public String getDescription() {
            return this.desc;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AppliedPatchInfoImpl that = (AppliedPatchInfoImpl)o;
            if (!this.desc.equals(that.desc)) {
                return false;
            }
            return this.issueKey.equals(that.issueKey);
        }

        public int hashCode() {
            int result = this.issueKey.hashCode();
            result = 31 * result + this.desc.hashCode();
            return result;
        }

        @Override
        public int compareTo(AppliedPatchInfo o) {
            if (this.equals(o)) {
                return 0;
            }
            int rc = this.issueKey.compareTo(o.getIssueKey());
            if (rc == 0) {
                rc = this.desc.compareTo(o.getDescription());
            }
            return rc;
        }

        public String toString() {
            return this.issueKey + " : " + this.desc;
        }
    }
}

