/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util.system.probes;

import com.atlassian.jira.config.database.DatabaseType;
import com.atlassian.jira.ofbiz.OfBizConnectionFactory;
import com.atlassian.jira.util.system.SystemInfoUtils;
import com.atlassian.jira.util.system.SystemInfoUtilsImpl;
import com.atlassian.jira.util.system.probes.ClusteredDatabaseProbe;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Objects;
import org.apache.log4j.Logger;

public class AwsAuroraPostgreSQLProbe
implements ClusteredDatabaseProbe {
    protected final Logger log = Logger.getLogger(AwsAuroraPostgreSQLProbe.class);
    static final String AURORA_VERSION_QUERY = "select AURORA_VERSION() as aurora_version";
    static final String AURORA_COUNT_CLUSTER_MEMBERS_QUERY = "SELECT count(server_id) as member_count FROM AURORA_REPLICA_STATUS();";
    private static final String AWS_AURORA_DB_NAME = "Aurora PostgreSQL";
    private static final String AURORA_VERSION_DB_COLUMN_NAME = "aurora_version";
    private static final String MEMBER_COUNT_DB_COLUMN_NAME = "member_count";
    private final OfBizConnectionFactory connectionFactory;

    public AwsAuroraPostgreSQLProbe(OfBizConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public SystemInfoUtils.ClusteredDatabaseMetadata getClusteredDatabaseMetadata() {
        try {
            Connection connection = this.connectionFactory.getConnection();
            try {
                SystemInfoUtilsImpl.ClusteredDatabaseMetaDataImpl clusteredDatabaseMetaDataImpl;
                block40: {
                    int memberCount;
                    String version;
                    ResultSet resultSet;
                    Statement statement = connection.createStatement();
                    try {
                        try {
                            resultSet = statement.executeQuery(AURORA_VERSION_QUERY);
                            try {
                                resultSet.next();
                                version = resultSet.getObject(AURORA_VERSION_DB_COLUMN_NAME, String.class);
                            }
                            finally {
                                if (resultSet != null) {
                                    resultSet.close();
                                }
                            }
                        }
                        catch (SQLException ex) {
                            AwsAuroraPostgreSQLProbe.debugLogQueryAndException(this.log, AURORA_VERSION_QUERY, ex);
                            SystemInfoUtils.ClusteredDatabaseMetadata clusteredDatabaseMetadata = null;
                            if (statement != null) {
                                statement.close();
                            }
                            if (connection != null) {
                                connection.close();
                            }
                            return clusteredDatabaseMetadata;
                        }
                    }
                    catch (Throwable throwable) {
                        if (statement != null) {
                            try {
                                statement.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    try {
                        resultSet = statement.executeQuery(AURORA_COUNT_CLUSTER_MEMBERS_QUERY);
                        try {
                            resultSet.next();
                            memberCount = resultSet.getInt(MEMBER_COUNT_DB_COLUMN_NAME);
                        }
                        finally {
                            if (resultSet != null) {
                                resultSet.close();
                            }
                        }
                    }
                    catch (SQLException ex) {
                        AwsAuroraPostgreSQLProbe.debugLogQueryAndException(this.log, AURORA_COUNT_CLUSTER_MEMBERS_QUERY, ex);
                        SystemInfoUtils.ClusteredDatabaseMetadata clusteredDatabaseMetadata = null;
                        if (statement != null) {
                            statement.close();
                        }
                        if (connection != null) {
                            connection.close();
                        }
                        return clusteredDatabaseMetadata;
                    }
                    clusteredDatabaseMetaDataImpl = new SystemInfoUtilsImpl.ClusteredDatabaseMetaDataImpl(AWS_AURORA_DB_NAME, version, memberCount);
                    if (statement == null) break block40;
                    statement.close();
                }
                return clusteredDatabaseMetaDataImpl;
            }
            finally {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (Throwable throwable) {
                        Throwable throwable3;
                        throwable3.addSuppressed(throwable);
                    }
                }
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Aurora PostgreSQL probe is unable to retrieve metadata from database. There may have been an issue using the supplied database connection", (Throwable)e);
            return null;
        }
    }

    @Override
    public boolean canProbe(String databaseType) {
        boolean isPostgres = Objects.equals(DatabaseType.POSTGRES.getTypeName(), databaseType);
        boolean isAuroraPostgres = Objects.equals(DatabaseType.AURORA_POSTGRES.getTypeName(), databaseType);
        return isPostgres || isAuroraPostgres;
    }

    private static void debugLogQueryAndException(Logger logger, String query, SQLException ex) {
        logger.debug((Object)String.format("Unable to extract results from query - %s", query), (Throwable)ex);
    }
}

