/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util.tomcat;

import com.atlassian.annotations.Internal;
import com.atlassian.jira.util.tomcat.TomcatConfigReaderHelper;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.Query;
import javax.management.QueryExp;

@Internal
public class DefaultTomcatConfigReaderHelper
implements TomcatConfigReaderHelper {
    private static final QueryExp PROTOCOL_STARTS_WITH_HTTP = Query.initialSubString(Query.attr("protocol"), Query.value("HTTP"));
    private final MBeanServer mBeanServer;

    public DefaultTomcatConfigReaderHelper(MBeanServer mBeanServer) {
        this.mBeanServer = Objects.requireNonNull(mBeanServer);
    }

    @Override
    public int getMaxHttpThreads() {
        return (Integer)this.getAttributeFromFirstHttpConnector("maxThreads");
    }

    @Override
    public List<Object> getAttributeFromAllHttpConnectors(String attributeName) {
        try {
            return this.tryToGetAttributeFromAllHttpConnectors(attributeName);
        }
        catch (JMException e) {
            throw new RuntimeException(e);
        }
    }

    private List<Object> tryToGetAttributeFromAllHttpConnectors(String attributeName) throws JMException {
        Set<ObjectName> httpConnectors = this.getHttpConnectors();
        ArrayList<Object> objects = new ArrayList<Object>(httpConnectors.size());
        for (ObjectName connector : httpConnectors) {
            objects.add(this.mBeanServer.getAttribute(connector, attributeName));
        }
        return objects;
    }

    @VisibleForTesting
    Object getAttributeFromFirstHttpConnector(String attributeName) {
        try {
            return this.mBeanServer.getAttribute(this.getFirstHttpConnector(), attributeName);
        }
        catch (JMException e) {
            throw new RuntimeException(e);
        }
    }

    private ObjectName getFirstHttpConnector() {
        return (ObjectName)this.getHttpConnectors().stream().findFirst().orElseThrow(() -> new RuntimeException("No Connector found in Tomcat configuration"));
    }

    private Set<ObjectName> getHttpConnectors() {
        try {
            return this.mBeanServer.queryNames(new ObjectName("*:type=Connector,*"), PROTOCOL_STARTS_WITH_HTTP);
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalStateException(e);
        }
    }
}

