/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util.xml;

import com.atlassian.jira.imports.project.util.XMLEscapeUtil;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Queue;

public class XMLEscapingReader
extends Reader {
    private final Reader in;
    private final Queue<Character> overflow = new ArrayDeque<Character>();

    public XMLEscapingReader(Reader in) {
        this.in = in;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        int lengthPutFromOverflow = 0;
        for (int i = off; i < off + len && !this.overflow.isEmpty(); ++i) {
            ++lengthPutFromOverflow;
            cbuf[i] = this.overflow.remove().charValue();
        }
        if (len == lengthPutFromOverflow) {
            return len;
        }
        if (!this.overflow.isEmpty()) {
            throw new IllegalStateException("Reader in inconsistent state: overflow should be empty but it contained the following value: " + Arrays.toString(this.overflow.toArray()));
        }
        int lengthRead = this.in.read(cbuf, off + lengthPutFromOverflow, len - lengthPutFromOverflow);
        if (lengthRead > 0) {
            return lengthPutFromOverflow + XMLEscapeUtil.unicodeInPlaceEncode(cbuf, off + lengthPutFromOverflow, lengthRead, len - lengthPutFromOverflow, this.overflow);
        }
        if (lengthPutFromOverflow > 0) {
            return lengthPutFromOverflow;
        }
        return -1;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }
}

