/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.versioning;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.issue.index.IndexDirectoryFactory;
import com.atlassian.jira.transaction.TransactionSupport;
import com.atlassian.jira.util.stats.JiraStats;
import com.atlassian.jira.util.stats.LongStats;
import com.atlassian.jira.util.stats.MutableLongStats;
import com.atlassian.jira.versioning.EntityVersion;
import com.atlassian.jira.versioning.EntityVersioningManager;
import com.atlassian.jira.versioning.EntityVersioningManagerImpl;
import com.atlassian.jira.versioning.IncrementDeletedEntityVersionException;
import com.atlassian.jira.versioning.VersioningDaoFactory;
import com.atlassian.plugin.event.events.PluginFrameworkShutdownEvent;
import com.atlassian.plugin.event.events.PluginFrameworkStartedEvent;
import com.google.common.base.Stopwatch;
import com.google.common.base.Ticker;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.gson.Gson;
import java.io.IOException;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityVersioningManagerWithStats
implements EntityVersioningManager {
    private static final Logger log = LoggerFactory.getLogger(EntityVersioningManagerWithStats.class);
    private static TotalAndSnapshotEntityVersioningManagerStats STATS;
    private static Ticker TICKER;
    private final ScheduledExecutorService executorService;
    private EntityVersioningManager delegate;
    private EventPublisher eventPublisher;

    public EntityVersioningManagerWithStats(VersioningDaoFactory factory, TransactionSupport transactionSupport, EventPublisher eventPublisher) {
        this(new EntityVersioningManagerImpl(factory, transactionSupport, eventPublisher), eventPublisher);
    }

    EntityVersioningManagerWithStats(EntityVersioningManager delegate, EventPublisher eventPublisher) {
        STATS = new TotalAndSnapshotEntityVersioningManagerStats();
        this.delegate = delegate;
        this.eventPublisher = eventPublisher;
        this.executorService = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("versioning-stats-%d").build());
        eventPublisher.register((Object)this);
    }

    private void start() {
        long periodInMin = JiraStats.statsLoggingInterval((TimeUnit)TimeUnit.MINUTES);
        log.info("[VERSIONING] versioning stats will be running every: {} min", (Object)periodInMin);
        this.executorService.scheduleAtFixedRate(this::onPeriodicStats, 0L, periodInMin, TimeUnit.MINUTES);
    }

    private void stop() {
        this.executorService.shutdownNow();
    }

    @EventListener
    public void onPluginFrameworkStarted(PluginFrameworkStartedEvent event) {
        this.start();
    }

    @EventListener
    public void onPluginFrameworkShutdown(PluginFrameworkShutdownEvent event) {
        this.stop();
    }

    synchronized void onPeriodicStats() {
        try {
            MutableEntityVersioningManagerStats.Result totalResult = STATS.getTotal();
            MutableEntityVersioningManagerStats.Result snapshotResult = STATS.getSnapshotAndReset();
            Gson gson = new Gson();
            String totalJson = gson.toJson((Object)totalResult);
            String snapshotJson = gson.toJson((Object)snapshotResult);
            log.info("[JIRA-STATS] {}total stats: {}", (Object)"[VERSIONING] ", (Object)totalJson);
            log.info("[JIRA-STATS] {}snapshot stats: {}", (Object)"[VERSIONING] ", (Object)snapshotJson);
        }
        catch (Throwable throwable) {
            log.error("{}Error when getting periodic indexing stats: {}", new Object[]{"[VERSIONING] ", throwable.getMessage(), throwable});
        }
    }

    static void requestStart() {
        if (STATS != null) {
            STATS.startRequestContext(TICKER);
        }
    }

    static void requestStop() {
        if (STATS != null) {
            STATS.stopRequestContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void incrementIssueVersion(long issueId) throws IncrementDeletedEntityVersionException {
        Stopwatch stopwatch = Stopwatch.createStarted((Ticker)TICKER);
        try {
            this.delegate.incrementIssueVersion(issueId);
        }
        finally {
            STATS.incrementIssueVersion(stopwatch.elapsed(TimeUnit.MILLISECONDS));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void incrementCommentVersion(long commentId, long parentIssueId) throws IncrementDeletedEntityVersionException {
        Stopwatch stopwatch = Stopwatch.createStarted((Ticker)TICKER);
        try {
            this.delegate.incrementCommentVersion(commentId, parentIssueId);
        }
        finally {
            STATS.incrementCommentVersion(stopwatch.elapsed(TimeUnit.MILLISECONDS));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void incrementWorklogVersion(long worklogId, long parentIssueId) throws IncrementDeletedEntityVersionException {
        Stopwatch stopwatch = Stopwatch.createStarted((Ticker)TICKER);
        try {
            this.delegate.incrementWorklogVersion(worklogId, parentIssueId);
        }
        finally {
            STATS.incrementWorklogVersion(stopwatch.elapsed(TimeUnit.MILLISECONDS));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void incrementRelatedCommentVersions(long parentIssueId) {
        Stopwatch stopwatch = Stopwatch.createStarted((Ticker)TICKER);
        try {
            this.delegate.incrementRelatedCommentVersions(parentIssueId);
        }
        finally {
            STATS.incrementRelatedCommentVersions(stopwatch.elapsed(TimeUnit.MILLISECONDS));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void incrementRelatedWorklogVersions(long parentIssueId) {
        Stopwatch stopwatch = Stopwatch.createStarted((Ticker)TICKER);
        try {
            this.delegate.incrementRelatedWorklogVersions(parentIssueId);
        }
        finally {
            STATS.incrementRelatedWorklogVersions(stopwatch.elapsed(TimeUnit.MILLISECONDS));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void markIssueDeletedAndIncrementVersion(long issueId) {
        Stopwatch stopwatch = Stopwatch.createStarted((Ticker)TICKER);
        try {
            this.delegate.markIssueDeletedAndIncrementVersion(issueId);
        }
        finally {
            STATS.markIssueDeletedAndIncrementVersion(stopwatch.elapsed(TimeUnit.MILLISECONDS));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void markCommentDeletedAndIncrementVersion(long commentId) {
        Stopwatch stopwatch = Stopwatch.createStarted((Ticker)TICKER);
        try {
            this.delegate.markCommentDeletedAndIncrementVersion(commentId);
        }
        finally {
            STATS.markCommentDeletedAndIncrementVersion(stopwatch.elapsed(TimeUnit.MILLISECONDS));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void markWorklogDeletedAndIncrementVersion(long worklogId) {
        Stopwatch stopwatch = Stopwatch.createStarted((Ticker)TICKER);
        try {
            this.delegate.markWorklogDeletedAndIncrementVersion(worklogId);
        }
        finally {
            STATS.markWorklogDeletedAndIncrementVersion(stopwatch.elapsed(TimeUnit.MILLISECONDS));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<Long> getIssueVersion(long issueId) {
        Stopwatch stopwatch = Stopwatch.createStarted((Ticker)TICKER);
        try {
            Optional<Long> optional = this.delegate.getIssueVersion(issueId);
            return optional;
        }
        finally {
            STATS.getIssueVersion(stopwatch.elapsed(TimeUnit.MILLISECONDS));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<EntityVersion> getIssueEntityVersion(long issueId) {
        Stopwatch stopwatch = Stopwatch.createStarted((Ticker)TICKER);
        try {
            Optional<EntityVersion> optional = this.delegate.getIssueEntityVersion(issueId);
            return optional;
        }
        finally {
            STATS.getIssueVersion(stopwatch.elapsed(TimeUnit.MILLISECONDS));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<Long> getCommentVersion(long commentId) {
        Stopwatch stopwatch = Stopwatch.createStarted((Ticker)TICKER);
        try {
            Optional<Long> optional = this.delegate.getCommentVersion(commentId);
            return optional;
        }
        finally {
            STATS.getCommentVersion(stopwatch.elapsed(TimeUnit.MILLISECONDS));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<EntityVersion> getCommentEntityVersion(long commentId) {
        Stopwatch stopwatch = Stopwatch.createStarted((Ticker)TICKER);
        try {
            Optional<EntityVersion> optional = this.delegate.getCommentEntityVersion(commentId);
            return optional;
        }
        finally {
            STATS.getCommentVersion(stopwatch.elapsed(TimeUnit.MILLISECONDS));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<Long> getWorklogVersion(long worklogId) {
        Stopwatch stopwatch = Stopwatch.createStarted((Ticker)TICKER);
        try {
            Optional<Long> optional = this.delegate.getWorklogVersion(worklogId);
            return optional;
        }
        finally {
            STATS.getWorklogVersion(stopwatch.elapsed(TimeUnit.MILLISECONDS));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<EntityVersion> getWorklogEntityVersion(long worklogId) {
        Stopwatch stopwatch = Stopwatch.createStarted((Ticker)TICKER);
        try {
            Optional<EntityVersion> optional = this.delegate.getWorklogEntityVersion(worklogId);
            return optional;
        }
        finally {
            STATS.getWorklogVersion(stopwatch.elapsed(TimeUnit.MILLISECONDS));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<Long, Long> getRelatedCommentVersions(long parentIssueId) {
        Stopwatch stopwatch = Stopwatch.createStarted((Ticker)TICKER);
        try {
            Map<Long, Long> map = this.delegate.getRelatedCommentVersions(parentIssueId);
            return map;
        }
        finally {
            STATS.getRelatedCommentVersions(stopwatch.elapsed(TimeUnit.MILLISECONDS));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<Long, Long> getRelatedWorklogVersions(long parentIssueId) {
        Stopwatch stopwatch = Stopwatch.createStarted((Ticker)TICKER);
        try {
            Map<Long, Long> map = this.delegate.getRelatedWorklogVersions(parentIssueId);
            return map;
        }
        finally {
            STATS.getRelatedWorklogVersions(stopwatch.elapsed(TimeUnit.MILLISECONDS));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<Long, Optional<Long>> getLocalVersions(Set<Long> entityIds, IndexDirectoryFactory.Name indexName) throws IOException {
        if (this.delegate instanceof EntityVersioningManagerImpl) {
            Stopwatch stopwatch = Stopwatch.createStarted((Ticker)TICKER);
            try {
                Map<Long, Optional<Long>> map = this.delegate.getLocalVersions(entityIds, indexName);
                return map;
            }
            finally {
                STATS.getLocalVersions(stopwatch.elapsed(TimeUnit.MILLISECONDS));
            }
        }
        throw new IllegalStateException(this.delegate + " is not an instance of " + EntityVersioningManagerImpl.class.getSimpleName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long cleanAllDeletedEntityVersionsOlderThan(Duration duration) {
        Stopwatch stopwatch = Stopwatch.createStarted((Ticker)TICKER);
        try {
            long l = this.delegate.cleanAllDeletedEntityVersionsOlderThan(duration);
            return l;
        }
        finally {
            STATS.cleanAllDeletedEntityVersionsOlderThan(stopwatch.elapsed(TimeUnit.MILLISECONDS));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<EntityVersion> findEntityVersionsUpdatedInTheLast(IndexDirectoryFactory.Name indexName, Duration duration) {
        Stopwatch stopwatch = Stopwatch.createStarted((Ticker)TICKER);
        try {
            List<EntityVersion> list = this.delegate.findEntityVersionsUpdatedInTheLast(indexName, duration);
            return list;
        }
        finally {
            STATS.findEntityVersionsUpdatedInLast(stopwatch.elapsed(TimeUnit.MILLISECONDS));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<EntityVersion> getLatestEntityUpdate(IndexDirectoryFactory.Name indexName) {
        Stopwatch stopwatch = Stopwatch.createStarted((Ticker)TICKER);
        try {
            Optional<EntityVersion> optional = this.delegate.getLatestEntityUpdate(indexName);
            return optional;
        }
        finally {
            STATS.getLatestEntityUpdate(stopwatch.elapsed(TimeUnit.MILLISECONDS));
        }
    }

    static {
        TICKER = Ticker.systemTicker();
    }

    private static class TotalAndSnapshotEntityVersioningManagerStats
    implements EntityVersioningManagerStats {
        private static final ThreadLocal<Stopwatch> requestTimeThreadLocal = new ThreadLocal();
        private static final ThreadLocal<MutableLongStats> requestMillisThreadLocal = new ThreadLocal();
        private final MutableEntityVersioningManagerStats total = new MutableEntityVersioningManagerStats();
        private final MutableEntityVersioningManagerStats snapshot = new MutableEntityVersioningManagerStats();

        private TotalAndSnapshotEntityVersioningManagerStats() {
        }

        void startRequestContext(Ticker ticker) {
            requestMillisThreadLocal.set(new MutableLongStats(new long[0]));
            requestTimeThreadLocal.set(Stopwatch.createStarted((Ticker)ticker));
        }

        public MutableEntityVersioningManagerStats.Result getTotal() {
            return this.total.get();
        }

        MutableEntityVersioningManagerStats.Result getSnapshotAndReset() {
            MutableEntityVersioningManagerStats.Result result = this.snapshot.get();
            this.snapshot.reset();
            return result;
        }

        void stopRequestContext() {
            MutableLongStats currentThreadRequestVersioningMillis = requestMillisThreadLocal.get();
            Stopwatch stopwatch = requestTimeThreadLocal.get();
            if (currentThreadRequestVersioningMillis != null && stopwatch != null) {
                LongStats requestMillis = currentThreadRequestVersioningMillis.get();
                long requestTimeMillis = stopwatch.elapsed(TimeUnit.MILLISECONDS);
                if (requestMillis.count > 0L) {
                    int percent = requestTimeMillis == 0L ? 0 : (int)(requestMillis.sum * 100L / requestTimeMillis);
                    this.request(requestMillis.sum, requestMillis.count, percent);
                }
            }
            requestTimeThreadLocal.remove();
            requestMillisThreadLocal.remove();
        }

        private void inRequest(long millis) {
            MutableLongStats currentThreadRequestMillis = requestMillisThreadLocal.get();
            if (currentThreadRequestMillis != null) {
                currentThreadRequestMillis.accept(millis);
            }
        }

        @Override
        public void request(long millis, long count, int percent) {
            this.total.request(millis, count, percent);
            this.snapshot.request(millis, count, percent);
        }

        @Override
        public void incrementIssueVersion(long millis) {
            this.total.incrementIssueVersion(millis);
            this.snapshot.incrementIssueVersion(millis);
            this.inRequest(millis);
        }

        @Override
        public void incrementCommentVersion(long millis) {
            this.total.incrementCommentVersion(millis);
            this.snapshot.incrementCommentVersion(millis);
            this.inRequest(millis);
        }

        @Override
        public void incrementWorklogVersion(long millis) {
            this.total.incrementWorklogVersion(millis);
            this.snapshot.incrementWorklogVersion(millis);
            this.inRequest(millis);
        }

        @Override
        public void incrementRelatedCommentVersions(long millis) {
            this.total.incrementRelatedCommentVersions(millis);
            this.snapshot.incrementRelatedCommentVersions(millis);
            this.inRequest(millis);
        }

        @Override
        public void incrementRelatedWorklogVersions(long millis) {
            this.total.incrementRelatedWorklogVersions(millis);
            this.snapshot.incrementRelatedWorklogVersions(millis);
            this.inRequest(millis);
        }

        @Override
        public void markIssueDeletedAndIncrementVersion(long millis) {
            this.total.markIssueDeletedAndIncrementVersion(millis);
            this.snapshot.markIssueDeletedAndIncrementVersion(millis);
            this.inRequest(millis);
        }

        @Override
        public void markCommentDeletedAndIncrementVersion(long millis) {
            this.total.markCommentDeletedAndIncrementVersion(millis);
            this.snapshot.markCommentDeletedAndIncrementVersion(millis);
            this.inRequest(millis);
        }

        @Override
        public void markWorklogDeletedAndIncrementVersion(long millis) {
            this.total.markWorklogDeletedAndIncrementVersion(millis);
            this.snapshot.markWorklogDeletedAndIncrementVersion(millis);
            this.inRequest(millis);
        }

        @Override
        public void getIssueVersion(long millis) {
            this.total.getIssueVersion(millis);
            this.snapshot.getIssueVersion(millis);
            this.inRequest(millis);
        }

        @Override
        public void getCommentVersion(long millis) {
            this.total.getCommentVersion(millis);
            this.snapshot.getCommentVersion(millis);
            this.inRequest(millis);
        }

        @Override
        public void getWorklogVersion(long millis) {
            this.total.getWorklogVersion(millis);
            this.snapshot.getWorklogVersion(millis);
            this.inRequest(millis);
        }

        @Override
        public void getRelatedCommentVersions(long millis) {
            this.total.getRelatedCommentVersions(millis);
            this.snapshot.getRelatedCommentVersions(millis);
            this.inRequest(millis);
        }

        @Override
        public void getRelatedWorklogVersions(long millis) {
            this.total.getRelatedWorklogVersions(millis);
            this.snapshot.getRelatedWorklogVersions(millis);
            this.inRequest(millis);
        }

        @Override
        public void getLocalVersions(long millis) {
            this.total.getLocalVersions(millis);
            this.snapshot.getLocalVersions(millis);
            this.inRequest(millis);
        }

        @Override
        public void markEntityDeletedAndIncrementVersion(long millis) {
            this.total.markEntityDeletedAndIncrementVersion(millis);
            this.snapshot.markEntityDeletedAndIncrementVersion(millis);
            this.inRequest(millis);
        }

        @Override
        public void cleanAllDeletedEntityVersionsOlderThan(long millis) {
            this.total.cleanAllDeletedEntityVersionsOlderThan(millis);
            this.snapshot.cleanAllDeletedEntityVersionsOlderThan(millis);
            this.inRequest(millis);
        }

        @Override
        public void findEntityVersionsUpdatedInLast(long millis) {
            this.total.findEntityVersionsUpdatedInLast(millis);
            this.snapshot.findEntityVersionsUpdatedInLast(millis);
            this.inRequest(millis);
        }

        @Override
        public void getLatestEntityUpdate(long millis) {
            this.total.getLatestEntityUpdate(millis);
            this.snapshot.getLatestEntityUpdate(millis);
            this.inRequest(millis);
        }
    }

    static class MutableEntityVersioningManagerStats
    implements EntityVersioningManagerStats {
        private final MutableLongStats requestMillis = new MutableLongStats(new long[]{1L, 5L, 10L, 50L, 100L, 200L});
        private final MutableLongStats requestCount = new MutableLongStats(new long[]{1L, 10L, 100L, 1000L});
        private final MutableLongStats requestPercent = new MutableLongStats(new long[]{1L, 3L, 5L, 10L, 20L, 30L});
        private final MutableLongStats incrementIssueVersionMillis = new MutableLongStats(new long[0]);
        private final MutableLongStats incrementCommentVersionMillis = new MutableLongStats(new long[0]);
        private final MutableLongStats incrementWorklogVersionMillis = new MutableLongStats(new long[0]);
        private final MutableLongStats incrementRelatedCommentVersionsMillis = new MutableLongStats(new long[0]);
        private final MutableLongStats incrementRelatedWorklogVersionsMillis = new MutableLongStats(new long[0]);
        private final MutableLongStats markIssueDeletedAndIncrementVersionMillis = new MutableLongStats(new long[0]);
        private final MutableLongStats markCommentDeletedAndIncrementVersionMillis = new MutableLongStats(new long[0]);
        private final MutableLongStats markWorklogDeletedAndIncrementVersionMillis = new MutableLongStats(new long[0]);
        private final MutableLongStats getIssueVersionMillis = new MutableLongStats(new long[0]);
        private final MutableLongStats getCommentVersionMillis = new MutableLongStats(new long[0]);
        private final MutableLongStats getWorklogVersionMillis = new MutableLongStats(new long[0]);
        private final MutableLongStats getRelatedCommentVersionsMillis = new MutableLongStats(new long[0]);
        private final MutableLongStats getRelatedWorklogVersionsMillis = new MutableLongStats(new long[0]);
        private final MutableLongStats getLocalVersionsMillis = new MutableLongStats(new long[]{1L, 5L, 10L, 50L, 100L, 500L, 1000L});
        private final MutableLongStats markEntityDeletedAndIncrementVersionMillis = new MutableLongStats(new long[0]);
        private final MutableLongStats cleanAllDeletedEntityVersionsOlderThanMillis = new MutableLongStats(new long[0]);
        private final MutableLongStats findEntityVersionsUpdatedInLastMillis = new MutableLongStats(new long[0]);
        private final MutableLongStats getLatestEntityUpdateMillis = new MutableLongStats(new long[0]);

        MutableEntityVersioningManagerStats() {
        }

        void reset() {
            this.requestMillis.reset();
            this.requestCount.reset();
            this.requestPercent.reset();
            this.incrementIssueVersionMillis.reset();
            this.incrementCommentVersionMillis.reset();
            this.incrementWorklogVersionMillis.reset();
            this.incrementRelatedCommentVersionsMillis.reset();
            this.incrementRelatedWorklogVersionsMillis.reset();
            this.markIssueDeletedAndIncrementVersionMillis.reset();
            this.markCommentDeletedAndIncrementVersionMillis.reset();
            this.markWorklogDeletedAndIncrementVersionMillis.reset();
            this.getIssueVersionMillis.reset();
            this.getCommentVersionMillis.reset();
            this.getWorklogVersionMillis.reset();
            this.getRelatedCommentVersionsMillis.reset();
            this.getRelatedWorklogVersionsMillis.reset();
            this.getLocalVersionsMillis.reset();
            this.markEntityDeletedAndIncrementVersionMillis.reset();
            this.cleanAllDeletedEntityVersionsOlderThanMillis.reset();
            this.findEntityVersionsUpdatedInLastMillis.reset();
            this.getLatestEntityUpdateMillis.reset();
        }

        @Override
        public void request(long millis, long count, int percent) {
            this.requestMillis.accept(millis);
            this.requestCount.accept(count);
            this.requestPercent.accept((long)percent);
        }

        @Override
        public void incrementIssueVersion(long millis) {
            this.incrementIssueVersionMillis.accept(millis);
        }

        @Override
        public void incrementCommentVersion(long millis) {
            this.incrementCommentVersionMillis.accept(millis);
        }

        @Override
        public void incrementWorklogVersion(long millis) {
            this.incrementWorklogVersionMillis.accept(millis);
        }

        @Override
        public void incrementRelatedCommentVersions(long millis) {
            this.incrementRelatedCommentVersionsMillis.accept(millis);
        }

        @Override
        public void incrementRelatedWorklogVersions(long millis) {
            this.incrementRelatedWorklogVersionsMillis.accept(millis);
        }

        @Override
        public void markIssueDeletedAndIncrementVersion(long millis) {
            this.markIssueDeletedAndIncrementVersionMillis.accept(millis);
        }

        @Override
        public void markCommentDeletedAndIncrementVersion(long millis) {
            this.markCommentDeletedAndIncrementVersionMillis.accept(millis);
        }

        @Override
        public void markWorklogDeletedAndIncrementVersion(long millis) {
            this.markWorklogDeletedAndIncrementVersionMillis.accept(millis);
        }

        @Override
        public void getIssueVersion(long millis) {
            this.getIssueVersionMillis.accept(millis);
        }

        @Override
        public void getCommentVersion(long millis) {
            this.getCommentVersionMillis.accept(millis);
        }

        @Override
        public void getWorklogVersion(long millis) {
            this.getWorklogVersionMillis.accept(millis);
        }

        @Override
        public void getRelatedCommentVersions(long millis) {
            this.getRelatedCommentVersionsMillis.accept(millis);
        }

        @Override
        public void getRelatedWorklogVersions(long millis) {
            this.getRelatedWorklogVersionsMillis.accept(millis);
        }

        @Override
        public void getLocalVersions(long millis) {
            this.getLocalVersionsMillis.accept(millis);
        }

        @Override
        public void markEntityDeletedAndIncrementVersion(long millis) {
            this.markEntityDeletedAndIncrementVersionMillis.accept(millis);
        }

        @Override
        public void cleanAllDeletedEntityVersionsOlderThan(long millis) {
            this.cleanAllDeletedEntityVersionsOlderThanMillis.accept(millis);
        }

        @Override
        public void findEntityVersionsUpdatedInLast(long millis) {
            this.findEntityVersionsUpdatedInLastMillis.accept(millis);
        }

        @Override
        public void getLatestEntityUpdate(long millis) {
            this.getLatestEntityUpdateMillis.accept(millis);
        }

        Result get() {
            return new Result();
        }

        class Result {
            private final LongStats requestMillis;
            private final LongStats requestCount;
            private final LongStats requestPercent;
            private final LongStats incrementIssueVersionMillis;
            private final LongStats incrementCommentVersionMillis;
            private final LongStats incrementWorklogVersionMillis;
            private final LongStats incrementRelatedCommentVersionsMillis;
            private final LongStats incrementRelatedWorklogVersionsMillis;
            private final LongStats markIssueDeletedAndIncrementVersionMillis;
            private final LongStats markCommentDeletedAndIncrementVersionMillis;
            private final LongStats markWorklogDeletedAndIncrementVersionMillis;
            private final LongStats getIssueVersionMillis;
            private final LongStats getCommentVersionMillis;
            private final LongStats getWorklogVersionMillis;
            private final LongStats getRelatedCommentVersionsMillis;
            private final LongStats getRelatedWorklogVersionsMillis;
            private final LongStats getLocalVersionsMillis;
            private final LongStats markEntityDeletedAndIncrementVersionMillis;
            private final LongStats cleanAllDeletedEntityVersionsOlderThanMillis;
            private final LongStats findEntityVersionsUpdatedInRangeMillis;
            private final LongStats getLatestEntityUpdateTimeMillis;

            Result() {
                this.requestMillis = MutableEntityVersioningManagerStats.this.requestMillis.get();
                this.requestCount = MutableEntityVersioningManagerStats.this.requestCount.get();
                this.requestPercent = MutableEntityVersioningManagerStats.this.requestPercent.get();
                this.incrementIssueVersionMillis = MutableEntityVersioningManagerStats.this.incrementIssueVersionMillis.get();
                this.incrementCommentVersionMillis = MutableEntityVersioningManagerStats.this.incrementCommentVersionMillis.get();
                this.incrementWorklogVersionMillis = MutableEntityVersioningManagerStats.this.incrementWorklogVersionMillis.get();
                this.incrementRelatedCommentVersionsMillis = MutableEntityVersioningManagerStats.this.incrementRelatedCommentVersionsMillis.get();
                this.incrementRelatedWorklogVersionsMillis = MutableEntityVersioningManagerStats.this.incrementRelatedWorklogVersionsMillis.get();
                this.markIssueDeletedAndIncrementVersionMillis = MutableEntityVersioningManagerStats.this.markIssueDeletedAndIncrementVersionMillis.get();
                this.markCommentDeletedAndIncrementVersionMillis = MutableEntityVersioningManagerStats.this.markCommentDeletedAndIncrementVersionMillis.get();
                this.markWorklogDeletedAndIncrementVersionMillis = MutableEntityVersioningManagerStats.this.markWorklogDeletedAndIncrementVersionMillis.get();
                this.getIssueVersionMillis = MutableEntityVersioningManagerStats.this.getIssueVersionMillis.get();
                this.getCommentVersionMillis = MutableEntityVersioningManagerStats.this.getCommentVersionMillis.get();
                this.getWorklogVersionMillis = MutableEntityVersioningManagerStats.this.getWorklogVersionMillis.get();
                this.getRelatedCommentVersionsMillis = MutableEntityVersioningManagerStats.this.getRelatedCommentVersionsMillis.get();
                this.getRelatedWorklogVersionsMillis = MutableEntityVersioningManagerStats.this.getRelatedWorklogVersionsMillis.get();
                this.getLocalVersionsMillis = MutableEntityVersioningManagerStats.this.getLocalVersionsMillis.get();
                this.markEntityDeletedAndIncrementVersionMillis = MutableEntityVersioningManagerStats.this.markEntityDeletedAndIncrementVersionMillis.get();
                this.cleanAllDeletedEntityVersionsOlderThanMillis = MutableEntityVersioningManagerStats.this.cleanAllDeletedEntityVersionsOlderThanMillis.get();
                this.findEntityVersionsUpdatedInRangeMillis = MutableEntityVersioningManagerStats.this.findEntityVersionsUpdatedInLastMillis.get();
                this.getLatestEntityUpdateTimeMillis = MutableEntityVersioningManagerStats.this.getLatestEntityUpdateMillis.get();
            }
        }
    }

    private static interface EntityVersioningManagerStats {
        public void request(long var1, long var3, int var5);

        public void incrementIssueVersion(long var1);

        public void incrementCommentVersion(long var1);

        public void incrementWorklogVersion(long var1);

        public void incrementRelatedCommentVersions(long var1);

        public void incrementRelatedWorklogVersions(long var1);

        public void markIssueDeletedAndIncrementVersion(long var1);

        public void markCommentDeletedAndIncrementVersion(long var1);

        public void markWorklogDeletedAndIncrementVersion(long var1);

        public void getIssueVersion(long var1);

        public void getCommentVersion(long var1);

        public void getWorklogVersion(long var1);

        public void getRelatedCommentVersions(long var1);

        public void getRelatedWorklogVersions(long var1);

        public void getLocalVersions(long var1);

        public void markEntityDeletedAndIncrementVersion(long var1);

        public void cleanAllDeletedEntityVersionsOlderThan(long var1);

        public void findEntityVersionsUpdatedInLast(long var1);

        public void getLatestEntityUpdate(long var1);
    }
}

