/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin;

import com.atlassian.annotations.security.AdminOnly;
import com.atlassian.jira.help.HelpUrl;
import com.atlassian.jira.help.HelpUrls;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.util.json.JSONEscaper;
import com.atlassian.jira.web.action.ActionViewDataMappings;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.ozymandias.SafePluginPointAccess;
import com.atlassian.plugin.web.api.DynamicWebInterfaceManager;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@WebSudoRequired
@AdminOnly
public class ApplicationAccess
extends JiraWebActionSupport {
    private static final String DEFAPP_LOCATION = "webpanels.admin.defaultapp.selector";
    private static final String CLOSING_ANCHOR = "</a>";
    private final PageBuilderService pageBuilder;
    private final HelpUrls helpUrls;
    private final DynamicWebInterfaceManager dynamicWebInterfaceManager;

    public ApplicationAccess(PageBuilderService pageBuilder, HelpUrls helpUrls, DynamicWebInterfaceManager dynamicWebInterfaceManager) {
        this.pageBuilder = pageBuilder;
        this.helpUrls = helpUrls;
        this.dynamicWebInterfaceManager = dynamicWebInterfaceManager;
    }

    @SupportedMethods(value={RequestMethod.GET})
    protected String doExecute() {
        this.pageBuilder.assembler().resources().requireWebResource("jira.webresources:application-roles-init");
        this.pageBuilder.assembler().data().requireData("com.atlassian.jira.web.action.admin.application-access:upgrade-jira-url", this.helpUrls.getUrl("upgrading").getUrl());
        this.pageBuilder.assembler().data().requireData("com.atlassian.jira.web.action.admin.application-access:reduce-user-count-url", this.helpUrls.getUrl("user_management.reduce.count").getUrl());
        this.pageBuilder.assembler().data().requireData("com.atlassian.jira.web.action.admin.application-access:defapp-selector-webpanels", JSONEscaper.escape((String)this.renderPanel(DEFAPP_LOCATION, (ImmutableMap<String, Object>)ImmutableMap.of())));
        this.pageBuilder.assembler().data().requireData("com.atlassian.jira.web.action.admin.application-access:managing-groups-url", this.helpUrls.getUrl("jira-applications_access.managing_user_access_to_applications").getUrl());
        return "success";
    }

    @ActionViewDataMappings(value={"success"})
    public Map<String, Object> getDataMap() {
        String helpHtml = this.getI18nHelper().getText("application.access.sidebar.help", this.getLink("user_management.groups"), CLOSING_ANCHOR, this.getLink("application_access"), CLOSING_ANCHOR);
        return ImmutableMap.of((Object)"helpHtml", (Object)helpHtml);
    }

    private String getLink(String key) {
        HelpUrl helpUrl = this.helpUrls.getUrl(key);
        return String.format("<a href=\"%s\" target=\"_blank\">", helpUrl.getUrl());
    }

    private String renderPanel(String location, ImmutableMap<String, Object> context) {
        return (String)SafePluginPointAccess.call(() -> {
            List panels = this.dynamicWebInterfaceManager.getDisplayableWebPanels(location, (Map)ImmutableMap.of());
            return SafePluginPointAccess.to().modules((Iterable)panels, (descriptor, webPanel) -> webPanel.getHtml((Map)context)).stream().collect(Collectors.joining());
        }).getOrElse((Object)"");
    }
}

